''' $Id: apgen.l,v 1.4 1994/12/16 19:56:40 bjs Exp $
'''
.TH APGEN l "18 June 1993"
.SH NAME
apgen \- ASCII Parameter File Generator Utility
.SH SYNOPSIS
.B apgen
.I options
.I parameter-file
[
.I output-file
]
.SH DESCRIPTION
.I apgen
converts a binary parameter file to its ASCII equivalent.  The ASCII file
generated is executable via the CommServer script command.
.I apgen
correctly handles compressed and uncompressed parameter files.
.I apgen 
finds it necessary to comment out certain data (comment lines are preceded 
by #).  These are:
.TP 5n
.B \-
Server features that were at one point enabled, but are now disabled, 
the old settings will be shown in comments.
Note: server features that have never been enabled, will have no data.  
.TP
.B \-
Password information will be shown in comments.
.TP 
.B \-
Data that would require the user to intervine will be shown in comments.  
This includes certain server features data, some daemon information, and 
old menu information.
.TP 
.B \-
The NVS information will also be shown in comments.
.SH ARGUMENTS
.TP 6n
.B \-options
Switches controlling which parts of the parameter file are converted.  Multiple
options may be specified.
.TP
.B parameter-file
Binary (compressed or uncompressed) parameter file.
.TP
.B output-file
Optional argument for results.  If this argument is omitted, the results appear
on 
.I stdout.

.SH OPTIONS
.TP 14n
.B \-all
convert entire (all) parameter file.
.TP
.B \-arap
convert ARAP data.
.TP
.B \-daemons
convert DAEMONS data.
.TP
.B \-domain
convert DOMAIN data.
.TP
.B \-filter[:ip|ipx]
convert IP or IPX filter data. The [:ip] option will display ip filters.  The
[:ipx] option will display ipx rip, sap, and address filters. The default is
[:ip].
.TP
.B \-features
convert server FEATURES data.
.TP
.B \-ip
convert INTERNET data.
.TP
.B \-ipx
convert IPX data.
.TP
.B \-kerberos
convert KERBEROS data.
.TP
.B \-lineedit
convert port LINE EDIT data.
.TP
.B \-lpd
convert LPD data.
.TP
.B \-manager
convert MANAGER data.
.TP
.B \-menu
convert MENU, and NESTED MENU data.
.TP
.B \-nvs
convert NVS data.
.TP
.B \-parameter
convert PARAMETER SERVER data.
.TP
.B \-port[:<number>]
convert port data for port <number>.  Multiple \-port options will display multiple
ports while -port:all, or -port will display all ports.  This option will 
override the
.B \-arap, 
.B \-kerberos, 
.B \-lineedit, 
.B \-menu, 
.B \-ppp, 
.B \-securid, 
.B \-security, 
.B \-session, 
.B \-slip, 
.B \-telnet, 
and 
.B \-xremote 
options.  This means that the port information to be printed with those options
will now be printed with the rest of the port information.
.TP
.B \-ppp
convert PPP data.
.TP
.B \-rotary
convert ROTARY data.
.TP
.B \-route[:ip|ipx]
convert ROUTING data for :ip or :ipx.  The 
:ip option will display IP ROUTING data.  Issuing \-route will also display IP 
ROUTING data. The :ipx option will display ipx routes, and service data.
.TP
.B \-script
convert SCRIPT data.
.TP
.B \-securid
convert SECURID data.
.TP
.B \-security
convert SECURITY data.
.TP
.B \-server
convert SERVER data.  This option will override the
.B \-daemons,
.B \-features,
.B \-ip,
.B \-kerberos,
.B \-menu,
.B \-parameter,
.B \-ppp,
and
.B \-snmp. 
options.  This means that the server information to be printed with those 
options will now be printed with the rest of the server information.
.TP
.B \-service
convert LAT SERVICE data.
.TP
.B \-session
convert port SESSION data.
.TP
.B \-slip
convert port SLIP data.
.TP
.B \-snmp
convert internet SNMP data.
.TP
.B \-telnet
convert port TELNET data.
.TP
.B \-tn3270
convert TN3270 data.
.TP
.B \-verbose
display port related data for each port individually instead of using a 
\'port-list\'.  This may be
used in conjunction with the 
.B \-all, 
.B \-kerberos, 
.B \-lineedit, 
.B \-menu, 
.B \-port, 
.B \-ppp, 
.B \-security, 
.B \-session, 
.B \-slip, 
.B \-telnet, 
and 
.B \-xremote 
options.
.TP
.B \-xprinter
convert XPRINTER data.
.TP
.B \-xremote
convert XREMOTE data.
.SH EXAMPLES
.nf
Convert entire parameter file, and store it in everything_log:

     example% apgen -all param-file.prm everything_log

Convert all port information in parameter file, and store it in port_log:

     example% apgen -port param-file.prm port_log

Convert all port information pertaining to port 3 and port 6:

     example% apgen -port:3 -port:6 param-file.prm

Convert all port information pertaining to port 3 and port 6, and generate a 
verbose listing:

     example% apgen -port:3 -port:6 -verbose param-file.prm

Convert Kerberos information for both the server and all ports.

     example% apgen -kerberos param-file.prm

Convert port 3, port 6, and Kerberos information for server.  Note that 
entire port 3 and 6 information is shown (including kerberos port data):

     example% apgen -kerberos -port:3 -port:6 param-file.prm
.fi
.SH FILES
.nf
/tftpboot/parameter-file          Binary parameter file
output-file                       Result destination
stdout                            Result destination 
                                    (if output-file omitted)
/tmp/uncompressed_parameter-file  Parameter file, uncompressed.
.fi
.SH SEE ALSO
Supporting documentation.


