/*
 ** Structure : LINK_STR
 **    Length : 8
 */
#define LINK_STR_sizelen 8
#define LINK_STR_next 0
#define LINK_STR_prev 4
/*
 ** Structure : ARAP_S_INFO
 **    Length : 80
 */
#define ARAP_S_INFO_sizelen 80
#define ARAP_S_INFO_arap_node 0
#define ARAP_S_INFO_arap_zone 33
#define ARAP_S_INFO_arap_passwd 66
#define ARAP_S_INFO_arap_max_ports 75
#define ARAP_S_INFO_arap_users_network 76
#define ARAP_S_INFO_arap_users_node 78
/*
 ** Structure : ARAP_P_INFO
 **    Length : 42
 */
#define ARAP_P_INFO_sizelen 42
#define ARAP_P_INFO_arap_allowed 0
#define ARAP_P_INFO_arap_zone_access 1
#define ARAP_P_INFO_arap_zone 2
#define ARAP_P_INFO_arap_max_connect_time 36
#define ARAP_P_INFO_arap_guest_logins_ok 40
/*
 ** Structure : CCL_PTCHAR_STR
 **    Length : 60
 */
#define CCL_PTCHAR_STR_sizelen 60
#define CCL_PTCHAR_STR_ccl_script 0
#define CCL_PTCHAR_STR_modem_audible 33
#define CCL_PTCHAR_STR_cclFill 34
/*
 ** Structure : PORT_EXPANDED_PTCHR_STR
 **    Length : 72
 */
#define PORT_EXPANDED_PTCHR_STR_sizelen 72
#define PORT_EXPANDED_PTCHR_STR_username_prompt 0
#define PORT_EXPANDED_PTCHR_STR_password_prompt 26
#define PORT_EXPANDED_PTCHR_STR_userdata_string 52
#define PORT_EXPANDED_PTCHR_STR_userdata_string_length 68
#define PORT_EXPANDED_PTCHR_STR_fill1 70
/*
 ** Structure : LOCATION_STR
 **    Length : 52
 */
#define LOCATION_STR_sizelen 52
#define LOCATION_STR_service_name 0
#define LOCATION_STR_node_name 17
#define LOCATION_STR_destination_name 34
/*
 ** Structure : LINE_EDIT_STR
 **    Length : 14
 */
#define LINE_EDIT_STR_sizelen 14
#define LINE_EDIT_STR_backspace 0
#define LINE_EDIT_STR_forward 1
#define LINE_EDIT_STR_delete 2
#define LINE_EDIT_STR_end_of_line 3
#define LINE_EDIT_STR_beg_of_line 4
#define LINE_EDIT_STR_delete_line 5
#define LINE_EDIT_STR_delete_beg 6
#define LINE_EDIT_STR_prev_line 7
#define LINE_EDIT_STR_next_line 8
#define LINE_EDIT_STR_redisplay 9
#define LINE_EDIT_STR_quoting_char 10
#define LINE_EDIT_STR_insert_toggle 11
#define LINE_EDIT_STR_rtrn 12
#define LINE_EDIT_STR_cancel_passwd 13
/*
 ** Structure : PTCHAR_STR
 **    Length : 544
 */
#define PTCHAR_STR_sizelen 544
#define PTCHAR_STR_access 0
#define PTCHAR_STR_alternate_speed 1
#define PTCHAR_STR_authorized_groups 2
#define PTCHAR_STR_autobaud 34
#define PTCHAR_STR_autoconnect 35
#define PTCHAR_STR_autoprompt 36
#define PTCHAR_STR_backward_switch 37
#define PTCHAR_STR_break_type 38
#define PTCHAR_STR_broadcast 39
#define PTCHAR_STR_character_size 40
#define PTCHAR_STR_dedicated_preferred_service 42
#define PTCHAR_STR_dialup 94
#define PTCHAR_STR_dsrlogout 95
#define PTCHAR_STR_dtrwait 96
#define PTCHAR_STR_input_flow 97
#define PTCHAR_STR_output_flow 98
#define PTCHAR_STR_forward_switch 99
#define PTCHAR_STR_groups 100
#define PTCHAR_STR_inactivity 132
#define PTCHAR_STR_interrupts 133
#define PTCHAR_STR_line_edit_chars 134
#define PTCHAR_STR_apd_security_last 148
#define PTCHAR_STR_fill1 149
#define PTCHAR_STR_dsrwait 157
#define PTCHAR_STR_noloss 158
#define PTCHAR_STR_signal_check 159
#define PTCHAR_STR_script_echo 160
#define PTCHAR_STR_script_login 161
#define PTCHAR_STR_krb 162
#define PTCHAR_STR_menu 163
#define PTCHAR_STR_local_switch 164
#define PTCHAR_STR_loss 165
#define PTCHAR_STR_message_codes 166
#define PTCHAR_STR_modem_control 167
#define PTCHAR_STR_multisessions 168
#define PTCHAR_STR_pause 169
#define PTCHAR_STR_port_name 170
#define PTCHAR_STR_parity 187
#define PTCHAR_STR_password 188
#define PTCHAR_STR_TermType 189
#define PTCHAR_STR_utTermCode 211
#define PTCHAR_STR_utTn3278Type 212
#define PTCHAR_STR_utTn3270ErrLock 213
#define PTCHAR_STR_stop_bits 214
#define PTCHAR_STR_remote_modification 215
#define PTCHAR_STR_fill8 216
#define PTCHAR_STR_one_switch_char 217
#define PTCHAR_STR_multi_switch_char 218
#define PTCHAR_STR_forward_switch_ext 219
#define PTCHAR_STR_backward_switch_ext 225
#define PTCHAR_STR_local_switch_ext 231
#define PTCHAR_STR_fill2 237
#define PTCHAR_STR_dedicated_preferred_service_type 238
#define PTCHAR_STR_dedicated_preferred_service_flag 239
#define PTCHAR_STR_queuing 240
#define PTCHAR_STR_ring 241
#define PTCHAR_STR_security 242
#define PTCHAR_STR_session_limit 243
#define PTCHAR_STR_input_speed 244
#define PTCHAR_STR_output_speed 245
#define PTCHAR_STR_telnet_abort_output 246
#define PTCHAR_STR_telnet_attention 247
#define PTCHAR_STR_telnet_default_port 248
#define PTCHAR_STR_telnet_echo_mode 250
#define PTCHAR_STR_telnet_erase_character 251
#define PTCHAR_STR_telnet_erase_line 252
#define PTCHAR_STR_telnet_interrupt 253
#define PTCHAR_STR_telnet_newline 254
#define PTCHAR_STR_telnet_option_display 255
#define PTCHAR_STR_telnet_query 256
#define PTCHAR_STR_telnet_remote 258
#define PTCHAR_STR_telnet_synchronize 260
#define PTCHAR_STR_telnet_transmit 261
#define PTCHAR_STR_type 262
#define PTCHAR_STR_type_ahead 264
#define PTCHAR_STR_username 266
#define PTCHAR_STR_verification 283
#define PTCHAR_STR_telnet_binary_mode 284
#define PTCHAR_STR_line_edit_disabled 285
#define PTCHAR_STR_slip_port_addr 286
#define PTCHAR_STR_slip_remote_addr 290
#define PTCHAR_STR_slip_mask 294
#define PTCHAR_STR_slip_enabled 298
#define PTCHAR_STR_csi_escape 299
#define PTCHAR_STR_telnet_newline_filter 300
#define PTCHAR_STR_dedicated_preferred_service_ptype 301
#define PTCHAR_STR_telnet_window_size 302
#define PTCHAR_STR_telnet_idle_time 304
#define PTCHAR_STR_dcd_timeout 305
#define PTCHAR_STR_privileged_menu 306
#define PTCHAR_STR_eor_reflection 307
#define PTCHAR_STR_dialback_enabled 308
#define PTCHAR_STR_dialback_timeout 309
#define PTCHAR_STR_limited_view 310
#define PTCHAR_STR_default_session_mode 311
#define PTCHAR_STR_flow_control 312
#define PTCHAR_STR_input_flow_enabled 313
#define PTCHAR_STR_output_flow_enabled 314
#define PTCHAR_STR_resolve_service 315
#define PTCHAR_STR_internet_connect 316
#define PTCHAR_STR_autodedicated 317
#define PTCHAR_STR_connect_resume 318
#define PTCHAR_STR_tn3270_device 319
#define PTCHAR_STR_tn3270_xlat 327
#define PTCHAR_STR_tn3270_eor 335
#define PTCHAR_STR_tn3270_xtdattrs 336
#define PTCHAR_STR_xremote 337
#define PTCHAR_STR_xdm_ip_addr 338
#define PTCHAR_STR_xdm_query_type 342
#define PTCHAR_STR_TCPKeepalive 343
#define PTCHAR_STR_telnet_tn3270printerport 344
#define PTCHAR_STR_xdm_host 345
#define PTCHAR_STR_discard_rx_errors 396
#define PTCHAR_STR_save_session_mode 397
#define PTCHAR_STR_telnet_urgentbreak 398
#define PTCHAR_STR_unix_enabled 399
#define PTCHAR_STR_nestedMenus 400
#define PTCHAR_STR_privilegedNestedMenus 401
#define PTCHAR_STR_nestedMenusTopLevel 402
#define PTCHAR_STR_telnet_location 403
#define PTCHAR_STR_remoteDisconnectNotify 404
#define PTCHAR_STR_defaultDestControlled 405
#define PTCHAR_STR_username_filtering 406
#define PTCHAR_STR_telnetRs491 407
#define PTCHAR_STR_autoHangup 408
#define PTCHAR_STR_stopDTRWait 409
#define PTCHAR_STR_xonTimer 410
#define PTCHAR_STR_clr_inter_sec_tbl 411
#define PTCHAR_STR_cmd_size 412
#define PTCHAR_STR_rlogin_transparent_mode 414
#define PTCHAR_STR_SecurID 415
#define PTCHAR_STR_idle_timeout 416
#define PTCHAR_STR_local_prompt 418
#define PTCHAR_STR_tn3270_command_flag 439
#define PTCHAR_STR_temp_tn3270_device 440
#define PTCHAR_STR_param_moved 449
#define PTCHAR_STR_tcp_outbound_addr 450
#define PTCHAR_STR_fill21 454
#define PTCHAR_STR_tn3270_default_port 504
#define PTCHAR_STR_apd 506
#define PTCHAR_STR_apd_default_protocol 508
#define PTCHAR_STR_apd_timeout 510
#define PTCHAR_STR_slip_flags 511
#define PTCHAR_STR_login_duration 512
#define PTCHAR_STR_outboundsecurity 514
#define PTCHAR_STR_apd_noprompt 515
#define PTCHAR_STR_slip_autosend 516
#define PTCHAR_STR_tn3270_scanner 517
#define PTCHAR_STR_tn3270_prefixkeymap 518
#define PTCHAR_STR_tn3270_space_insert 519
#define PTCHAR_STR_tn3270_type_ahead 520
#define PTCHAR_STR_UseRadiusAcct 521
#define PTCHAR_STR_UseRadiusSolicit 522
#define PTCHAR_STR_UseRadius 523
#define PTCHAR_STR_dialoutProtocol 524
#define PTCHAR_STR_remoteAccessFill1 525
#define PTCHAR_STR_telnet_buff_time 526
#define PTCHAR_STR_fill3 528
/*
 ** Structure : NLINK_ADDR_STR
 **    Length : 6
 */
#define NLINK_ADDR_STR_sizelen 6
#define NLINK_ADDR_STR_high 0
#define NLINK_ADDR_STR_middle 2
#define NLINK_ADDR_STR_low 4
/*
 ** Structure : SESSION_STR
 **    Length : 166
 */
#define SESSION_STR_sizelen 166
#define SESSION_STR_scb_link 0
#define SESSION_STR_mode 8
#define SESSION_STR_type 9
#define SESSION_STR_org_type 10
#define SESSION_STR_curr_state 11
#define SESSION_STR_new_state 12
#define SESSION_STR_flow 13
#define SESSION_STR_major_evt 14
#define SESSION_STR_minor_evt 15
#define SESSION_STR_async_evt 16
#define SESSION_STR_bound 17
#define SESSION_STR_port_ptr 18
#define SESSION_STR_slot_ptr 22
#define SESSION_STR_in_ring 26
#define SESSION_STR_out_ring 30
#define SESSION_STR_io_pcb 34
#define SESSION_STR_name_map 38
#define SESSION_STR_service_name 39
#define SESSION_STR_timer_type 91
#define SESSION_STR_link_addr 92
#define SESSION_STR_retry_count 100
#define SESSION_STR_flags 102
#define SESSION_STR_request_id 104
#define SESSION_STR_queue_id 106
#define SESSION_STR_password 108
#define SESSION_STR_node 112
#define SESSION_STR_service 116
#define SESSION_STR_timer_ticks_left 120
#define SESSION_STR_timer_reset_value 122
#define SESSION_STR_acct_entry_num 124
#define SESSION_STR_connect_date 126
#define SESSION_STR_connect_time 130
#define SESSION_STR_bytes_in 134
#define SESSION_STR_bytes_out 138
#define SESSION_STR_session_number 142
#define SESSION_STR_origin 143
#define SESSION_STR_timestamp 144
#define SESSION_STR_validation 148
#define SESSION_STR_tcpkeepalive_timer 152
#define SESSION_STR_probe_retries 156
#define SESSION_STR_flag2 158
#define SESSION_STR_first_time 160
#define SESSION_STR_fill 161
#define SESSION_STR_userData 162
/*
 ** Structure : MANAGER_DATA_STR
 **    Length : 26
 */
#define MANAGER_DATA_STR_sizelen 26
#define MANAGER_DATA_STR_log_size 0
#define MANAGER_DATA_STR_max_threads 2
#define MANAGER_DATA_STR_dump_merit 3
#define MANAGER_DATA_STR_dump_enabled 4
#define MANAGER_DATA_STR_dump_size 5
#define MANAGER_DATA_STR_dump_drive 6
#define MANAGER_DATA_STR_loadDrive 7
#define MANAGER_DATA_STR_load_merit 8
#define MANAGER_DATA_STR_filler1 9
#define MANAGER_DATA_STR_filler2 10
#define MANAGER_DATA_STR_parameter_drive 11
#define MANAGER_DATA_STR_parameter_default 12
#define MANAGER_DATA_STR_log_fatal 13
#define MANAGER_DATA_STR_log_warning 17
#define MANAGER_DATA_STR_log_informative 21
/*
 ** Structure : SLOT_DATA_HDR
 **    Length : 32
 */
#define SLOT_DATA_HDR_sizelen 32
#define SLOT_DATA_HDR_rewriteCount 0
#define SLOT_DATA_HDR_checksum 2
#define SLOT_DATA_HDR_revLevel 4
#define SLOT_DATA_HDR_bootRecords 5
#define SLOT_DATA_HDR_dataOffset 6
#define SLOT_DATA_HDR_size 8
#define SLOT_DATA_HDR_whoType 10
#define SLOT_DATA_HDR_whoRev 11
#define SLOT_DATA_HDR_test 16
#define SLOT_DATA_HDR_fill02 19
#define SLOT_DATA_HDR_memSize 20
#define SLOT_DATA_HDR_controlFlags 24
#define SLOT_DATA_HDR_mainHwId 28
#define SLOT_DATA_HDR_ioHwId 30
/*
 ** Structure : NET_SELECT
 **    Length : 4
 */
#define NET_SELECT_sizelen 4
#define NET_SELECT_ctlrType 0
#define NET_SELECT_ctlrNumber 4
#define NET_SELECT_destClass 8
#define NET_SELECT_dest 11
#define NET_SELECT_portType 16
#define NET_SELECT_portNum 20
#define NET_SELECT_connector 28
/*
 ** Structure : BOOT_RECORD
 **    Length : 114
 */
#define BOOT_RECORD_sizelen 114
#define BOOT_RECORD_revLevel 0
#define BOOT_RECORD_flags 1
#define BOOT_RECORD_length 2
#define BOOT_RECORD_net_select 4
#define BOOT_RECORD_controlFlags 8
#define BOOT_RECORD_mopFileName 20
#define BOOT_RECORD_unitIpAddr 36
#define BOOT_RECORD_hostIpAddr 40
#define BOOT_RECORD_gatewayIpAddr 44
#define BOOT_RECORD_tftpFileName 48
#define BOOT_RECORD_tftpDelimiter 113
/*
 ** Structure : SLOT_SPECIFIC
 **    Length : 138
 */
#define SLOT_SPECIFIC_sizelen 138
#define SLOT_SPECIFIC_fill01 0
/*
 ** Structure : LB2_SLOT_NVS_STR
 **    Length : 512
 */
#define LB2_SLOT_NVS_STR_sizelen 512
#define LB2_SLOT_NVS_STR_hdr 0
#define LB2_SLOT_NVS_STR_boot 32
#define LB2_SLOT_NVS_STR_fill 374
/*
 ** Structure : SCCHAR_STR
 **    Length : 184
 */
#define SCCHAR_STR_sizelen 184
#define SCCHAR_STR_connections 0
#define SCCHAR_STR_identification 1
#define SCCHAR_STR_name 42
#define SCCHAR_STR_password 59
#define SCCHAR_STR_port_list 76
#define SCCHAR_STR_queue 92
#define SCCHAR_STR_rating 93
#define SCCHAR_STR_lat_service 94
#define SCCHAR_STR_telnet_service 95
#define SCCHAR_STR_x25_service 96
#define SCCHAR_STR_connect_action 97
#define SCCHAR_STR_ip_addr 162
#define SCCHAR_STR_x25_subaddr 166
#define SCCHAR_STR_fill 167
/*
 ** Structure : ROTARY_STR
 **    Length : 20
 */
#define ROTARY_STR_sizelen 20
#define ROTARY_STR_ip_address 0
#define ROTARY_STR_port_map 4
/*
 ** Structure : RADIUS_S_INFO
 **    Length : 96
 */
#define RADIUS_S_INFO_sizelen 96
#define RADIUS_S_INFO_Name 0
#define RADIUS_S_INFO_IpAddr 52
#define RADIUS_S_INFO_uBogusField 56
#define RADIUS_S_INFO_Secret 58
#define RADIUS_S_INFO_fill 91
/*
 ** Structure : RADIUS_P_INFO
 **    Length : 366
 */
#define RADIUS_P_INFO_sizelen 366
#define RADIUS_P_INFO_version 0
#define RADIUS_P_INFO_AuthPort 2
#define RADIUS_P_INFO_bLogging 4
#define RADIUS_P_INFO_ReqTimeout 5
#define RADIUS_P_INFO_SecretAuth 6
#define RADIUS_P_INFO_ChapChalSize 22
#define RADIUS_P_INFO_fill 23
#define RADIUS_P_INFO_AuthAttempts 27
#define RADIUS_P_INFO_server 28
#define RADIUS_P_INFO_AcctPort 316
#define RADIUS_P_INFO_AcctAttempts 318
#define RADIUS_P_INFO_AcctFill 320
#define RADIUS_P_INFO_radMessageString 326
/*
 ** Structure : SERVER_EXPANDED_SRCHAR_STR
 **    Length : 90
 */
#define SERVER_EXPANDED_SRCHAR_STR_sizelen 90
#define SERVER_EXPANDED_SRCHAR_STR_apdMessage 0
#define SERVER_EXPANDED_SRCHAR_STR_fill1 80
/*
 ** Structure : SERVER_EXPANDED_DATA_STR
 **    Length : 180
 */
#define SERVER_EXPANDED_DATA_STR_sizelen 180
#define SERVER_EXPANDED_DATA_STR_work 0
#define SERVER_EXPANDED_DATA_STR_perm 90
/*
 ** Structure : SNMP_COMMUNITY_STR2
 **    Length : 48
 */
#define SNMP_COMMUNITY_STR2_sizelen 48
#define SNMP_COMMUNITY_STR2_clients 0
/*
 ** Structure : SERVER_SNMP_EXP_SRCHAR_STR
 **    Length : 144
 */
#define SERVER_SNMP_EXP_SRCHAR_STR_sizelen 144
#define SERVER_SNMP_EXP_SRCHAR_STR_snmp_set2 0
#define SERVER_SNMP_EXP_SRCHAR_STR_snmp_get2 48
#define SERVER_SNMP_EXP_SRCHAR_STR_snmp_trap2 96
/*
 ** Structure : SNMP_COMMUNITY_STR
 **    Length : 58
 */
#define SNMP_COMMUNITY_STR_sizelen 58
#define SNMP_COMMUNITY_STR_community 0
#define SNMP_COMMUNITY_STR_clients 34
/*
 ** Structure : SRCHAR_STR
 **    Length : 1264
 */
#define SRCHAR_STR_sizelen 1264
#define SRCHAR_STR_announcements 0
#define SRCHAR_STR_broadcast 1
#define SRCHAR_STR_circuit_timer 2
#define SRCHAR_STR_console_port 3
#define SRCHAR_STR_date 4
#define SRCHAR_STR_dump 8
#define SRCHAR_STR_heartbeat 9
#define SRCHAR_STR_identification 10
#define SRCHAR_STR_old_inactivity_timer 51
#define SRCHAR_STR_keepalive_timer 52
#define SRCHAR_STR_lock 53
#define SRCHAR_STR_login_password 54
#define SRCHAR_STR_login_prompt 71
#define SRCHAR_STR_maintenance_password 80
#define SRCHAR_STR_multicast_timer 88
#define SRCHAR_STR_name 89
#define SRCHAR_STR_node_limit 106
#define SRCHAR_STR_number 108
#define SRCHAR_STR_password_limit 110
#define SRCHAR_STR_privileged_password 111
#define SRCHAR_STR_ps_polling 128
#define SRCHAR_STR_ps_poll_timer 129
#define SRCHAR_STR_ps_retry_timer 130
#define SRCHAR_STR_ps_retry_limit 131
#define SRCHAR_STR_ps_limit 132
#define SRCHAR_STR_queue_limit 133
#define SRCHAR_STR_retransmition_limit 134
#define SRCHAR_STR_service_groups 135
#define SRCHAR_STR_session_limit 167
#define SRCHAR_STR_software 168
#define SRCHAR_STR_time 186
#define SRCHAR_STR_welcome 190
#define SRCHAR_STR_ip_addr 272
#define SRCHAR_STR_ip_broadcast_addr 276
#define SRCHAR_STR_ip_name 280
#define SRCHAR_STR_ip_domain_suffix 331
#define SRCHAR_STR_ip_pdomain_addr 382
#define SRCHAR_STR_ip_sdomain_addr 386
#define SRCHAR_STR_ip_pgateway_addr 390
#define SRCHAR_STR_ip_sgateway_addr 394
#define SRCHAR_STR_ip_subnet_mask 398
#define SRCHAR_STR_txtpool_size 402
#define SRCHAR_STR_lat_disabled 404
#define SRCHAR_STR_telnet_disabled 405
#define SRCHAR_STR_tn3270_on 406
#define SRCHAR_STR_snmp_enabled 407
#define SRCHAR_STR_rlogin_enabled 408
#define SRCHAR_STR_auto_ip_mask 409
#define SRCHAR_STR_report_errors 410
#define SRCHAR_STR_ip_ttl 411
#define SRCHAR_STR_domain_ttl 412
#define SRCHAR_STR_security_entry_cnt 413
#define SRCHAR_STR_timezone 414
#define SRCHAR_STR_ident_size 416
#define SRCHAR_STR_param_level 417
#define SRCHAR_STR_ip_domain_extension 418
#define SRCHAR_STR_system_contact 484
#define SRCHAR_STR_system_location 545
#define SRCHAR_STR_old_set_community 606
#define SRCHAR_STR_set_community_switch 639
#define SRCHAR_STR_old_snmp_client 640
#define SRCHAR_STR_old_snmp_get_client 656
#define SRCHAR_STR_old_snmp_trap_client 672
#define SRCHAR_STR_old_get_community 688
#define SRCHAR_STR_old_trap_community 721
#define SRCHAR_STR_get_community_switch 754
#define SRCHAR_STR_menu_disabled 755
#define SRCHAR_STR_acct_size 756
#define SRCHAR_STR_tn3270_keymaps 758
#define SRCHAR_STR_change 759
#define SRCHAR_STR_dialback_limit 760
#define SRCHAR_STR_purge_node 761
#define SRCHAR_STR_purge_group 762
#define SRCHAR_STR_console_logout 763
#define SRCHAR_STR_packet_count 764
#define SRCHAR_STR_new_txtpool_size 766
#define SRCHAR_STR_lb2_segment 770
#define SRCHAR_STR_ipx_mac 771
#define SRCHAR_STR_ipx_ethernet 772
#define SRCHAR_STR_ppp_enabled 773
#define SRCHAR_STR_param_moved 774
#define SRCHAR_STR_tcp_resequencing 775
#define SRCHAR_STR_ip_reassembly 776
#define SRCHAR_STR_x25_enabled 777
#define SRCHAR_STR_pppPapPassword 778
#define SRCHAR_STR_mx800Unlocked 795
#define SRCHAR_STR_latSolicits 796
#define SRCHAR_STR_unix_enabled 797
#define SRCHAR_STR_host_log_type 798
#define SRCHAR_STR_verbose_accounting 799
#define SRCHAR_STR_priority_level 800
#define SRCHAR_STR_lpd_enabled 801
#define SRCHAR_STR_fingerd_enabled 802
#define SRCHAR_STR_routed_enabled 803
#define SRCHAR_STR_rwhod_enabled 804
#define SRCHAR_STR_controlledPorts 805
#define SRCHAR_STR_nestedMenusSize 806
#define SRCHAR_STR_nestedMenusName 810
#define SRCHAR_STR_tcpConnectTimer 827
#define SRCHAR_STR_syslogd_facility_mask 828
#define SRCHAR_STR_SecurID_enabled 829
#define SRCHAR_STR_tcp_local_port_base 830
#define SRCHAR_STR_tcp_local_increment 832
#define SRCHAR_STR_gateway_timeout 834
#define SRCHAR_STR_ipx_mac_802_2 836
#define SRCHAR_STR_ipx_mac_802_2_snap 837
#define SRCHAR_STR_tcpRoutingTblSz 838
#define SRCHAR_STR_ipx_xprinter_timeout 840
#define SRCHAR_STR_unix_syslog_addr 842
#define SRCHAR_STR_inactivity_timer 846
#define SRCHAR_STR_load_dir 848
#define SRCHAR_STR_snmp_auth_traps 889
#define SRCHAR_STR_kerberos_security 890
#define SRCHAR_STR_eventlog_disabled 891
#define SRCHAR_STR_xremote_enabled 892
#define SRCHAR_STR_kerberos_enabled 893
#define SRCHAR_STR_help_disabled 894
#define SRCHAR_STR_internet_security_disabled 895
#define SRCHAR_STR_multisessions_disabled 896
#define SRCHAR_STR_xprinter_enabled 897
#define SRCHAR_STR_snmp_set 898
#define SRCHAR_STR_snmp_get 956
#define SRCHAR_STR_snmp_trap 1014
#define SRCHAR_STR_telnet_k_a_time 1072
#define SRCHAR_STR_data_send_delay 1073
#define SRCHAR_STR_tcpRetranMin 1074
#define SRCHAR_STR_RadiusEnabled 1076
#define SRCHAR_STR_pppChapPassword 1077
#define SRCHAR_STR_overrideDefinedAddress 1094
#define SRCHAR_STR_RebootCounter 1095
#define SRCHAR_STR_unix_syslog_addr2 1096
#define SRCHAR_STR_host_log_type2 1100
#define SRCHAR_STR_RotaryRoundRobin 1101
#define SRCHAR_STR_fill6 1102
#define SRCHAR_STR_snmpResourceFailTrap 1234
#define SRCHAR_STR_snmpMemCardChangeTrap 1235
#define SRCHAR_STR_snmpLoginTrap 1236
#define SRCHAR_STR_snmpLinkTrap 1237
#define SRCHAR_STR_snmpSessionTrap 1238
#define SRCHAR_STR_timeServerStatus 1239
#define SRCHAR_STR_timeServer 1240
#define SRCHAR_STR_reliableAcct 1244
#define SRCHAR_STR_lat_immediate_ack 1245
#define SRCHAR_STR_kerberos5_enabled 1246
#define SRCHAR_STR_arap_enabled 1247
#define SRCHAR_STR_null_clock 1248
#define SRCHAR_STR_ARP_TTL 1249
#define SRCHAR_STR_ipxRipTableSize 1250
#define SRCHAR_STR_ipxSapTableSize 1252
#define SRCHAR_STR_ipxRouting_enabled 1254
#define SRCHAR_STR_apd_enabled 1255
#define SRCHAR_STR_ipxFiltering_enabled 1256
#define SRCHAR_STR_ipFiltering_enabled 1257
#define SRCHAR_STR_ps_tftp_no_readbroadcast 1258
#define SRCHAR_STR_TcpAckDelay 1259
#define SRCHAR_STR_ipxInternalNetwork 1260
/*
 ** Structure : PARAM_STR
 **    Length : 68
 */
#define PARAM_STR_sizelen 68
#define PARAM_STR_link 0
#define PARAM_STR_node_addr 8
#define PARAM_STR_name 14
#define PARAM_STR_version 32
#define PARAM_STR_change_date 36
#define PARAM_STR_change_time 40
#define PARAM_STR_status 44
#define PARAM_STR_reason 45
#define PARAM_STR_send_segment 46
#define PARAM_STR_ack_segment 47
#define PARAM_STR_check_retries 48
#define PARAM_STR_flags 49
#define PARAM_STR_tftp_fh 50
#define PARAM_STR_tftp_name_state 54
#define PARAM_STR_bck_version 56
#define PARAM_STR_prm_version 60
#define PARAM_STR_size 64
#define PARAM_STR_pad 66
/*
 ** Structure : BS2_STR_TAG
 **    Length : 20
 */
#define BS2_STR_TAG_sizelen 20
#define BS2_STR_TAG_validation 0
#define BS2_STR_TAG_type 16
#define BS2_STR_TAG_length 18
/*
 ** Structure : PARAM_LOAD_STR
 **    Length : 82
 */
#define PARAM_LOAD_STR_sizelen 82
#define PARAM_LOAD_STR_bs2 0
#define PARAM_LOAD_STR_version 20
#define PARAM_LOAD_STR_date 24
#define PARAM_LOAD_STR_time 28
#define PARAM_LOAD_STR_differential_hours 32
#define PARAM_LOAD_STR_differential_minutes 33
#define PARAM_LOAD_STR_software_type 34
#define PARAM_LOAD_STR_stored_format 38
#define PARAM_LOAD_STR_oldest_format 40
#define PARAM_LOAD_STR_hardware_type 42
#define PARAM_LOAD_STR_software_version_major 44
#define PARAM_LOAD_STR_software_version_minor 45
#define PARAM_LOAD_STR_software_version_eco 46
#define PARAM_LOAD_STR_software_version_type 47
#define PARAM_LOAD_STR_software_version_prerelease 48
#define PARAM_LOAD_STR_software_product 49
#define PARAM_LOAD_STR_fill 50
/*
 ** Structure : IP_SECURITY_ENTRY_STR
 **    Length : 28
 */
#define IP_SECURITY_ENTRY_STR_sizelen 28
#define IP_SECURITY_ENTRY_STR_ip_addr 0
#define IP_SECURITY_ENTRY_STR_network_mask 4
#define IP_SECURITY_ENTRY_STR_direction 8
#define IP_SECURITY_ENTRY_STR_access_type 9
#define IP_SECURITY_ENTRY_STR_significance 10
#define IP_SECURITY_ENTRY_STR_port_list 11
/*
 ** Structure : MENU_STR
 **    Length : 96
 */
#define MENU_STR_sizelen 96
#define MENU_STR_menu_display 0
#define MENU_STR_menu_command 31
/*
 ** Structure : MENU_TEXT_STR
 **    Length : 102
 */
#define MENU_TEXT_STR_sizelen 102
#define MENU_TEXT_STR_continue_prompt 0
#define MENU_TEXT_STR_menu_prompt 51
/*
 ** Structure : KRB_PARAM_739MSG
 **    Length : 170
 */
#define KRB_PARAM_739MSG_sizelen 170
#define KRB_PARAM_739MSG_text 0
#define KRB_PARAM_739MSG_service 132
#define KRB_PARAM_739MSG_fill3 149
/*
 ** Structure : SMAP
 **    Length : 10
 */
#define SMAP_sizelen 10
#define SMAP_len 0
#define SMAP_code 1
/*
 ** Structure : LSMAP
 **    Length : 16
 */
#define LSMAP_sizelen 16
#define LSMAP_len 0
#define LSMAP_code 1
/*
 ** Structure : SCB
 **    Length : 346
 */
#define SCB_sizelen 346
#define SCB_smap 0
#define SCB_sline 240
#define SCB_reset 272
#define SCB_base 336
#define SCB_sgr 337
#define SCB_future 338
/*
 ** Structure : KMAP
 **    Length : 14
 */
#define KMAP_sizelen 14
#define KMAP_len 0
#define KMAP_code 1
#define KMAP_desc 9
/*
 ** Structure : KCB
 **    Length : 980
 */
#define KCB_sizelen 980
#define KCB_kmap 0
/*
 ** Structure : DCB
 **    Length : 1366
 */
#define DCB_sizelen 1366
#define DCB_next 0
#define DCB_prev 4
#define DCB_name 8
#define DCB_ttyp 17
#define DCB_model 39
#define DCB_scb 40
#define DCB_kcb 386
/*
 ** Structure : XCB
 **    Length : 530
 */
#define XCB_sizelen 530
#define XCB_next 0
#define XCB_prev 4
#define XCB_name 8
#define XCB_e2a 17
#define XCB_a2e 273
/*
 ** Structure : SCRIPT_BLOCK
 **    Length : 128
 */
#define SCRIPT_BLOCK_sizelen 128
#define SCRIPT_BLOCK_host 0
#define SCRIPT_BLOCK_path 51
#define SCRIPT_BLOCK_separator 116
#define SCRIPT_BLOCK_filler 118
/*
 ** Structure : PPP_PTCHAR_STR
 **    Length : 80
 */
#define PPP_PTCHAR_STR_sizelen 80
#define PPP_PTCHAR_STR_ppp_port_addr 0
#define PPP_PTCHAR_STR_ppp_remote_addr 4
#define PPP_PTCHAR_STR_ppp_charmap 8
#define PPP_PTCHAR_STR_ppp_range_start 12
#define PPP_PTCHAR_STR_ppp_range_end 16
#define PPP_PTCHAR_STR_ppp_katimeout 20
#define PPP_PTCHAR_STR_ppp_katimer 22
#define PPP_PTCHAR_STR_ppp_enabled 23
#define PPP_PTCHAR_STR_ppp_ip_enabled 24
#define PPP_PTCHAR_STR_ppp_logging 25
#define PPP_PTCHAR_STR_pppPapEnabled 26
#define PPP_PTCHAR_STR_pppBroadcastEnabled 27
#define PPP_PTCHAR_STR_pppActiveEnabled 28
#define PPP_PTCHAR_STR_pppVJCompEnabled 29
#define PPP_PTCHAR_STR_ppp_rtimer 30
#define PPP_PTCHAR_STR_ppp_maxconf 31
#define PPP_PTCHAR_STR_ppp_flags 32
#define PPP_PTCHAR_STR_ppp_maxfail 33
#define PPP_PTCHAR_STR_ppp_maxtries 34
#define PPP_PTCHAR_STR_ppp_vjslots 35
#define PPP_PTCHAR_STR_pppIpMask 36
#define PPP_PTCHAR_STR_pppChapEnabled 40
#define PPP_PTCHAR_STR_pppChapChallengeTimer 41
#define PPP_PTCHAR_STR_fill1 42
#define PPP_PTCHAR_STR_pppMagicNumDisabled 49
#define PPP_PTCHAR_STR_ppp_localrange_start 50
#define PPP_PTCHAR_STR_ppp_localrange_end 54
#define PPP_PTCHAR_STR_fill2 58
/*
 ** Structure : SD_SERVER
 **    Length : 56
 */
#define SD_SERVER_sizelen 56
#define SD_SERVER_name 0
#define SD_SERVER_resolve_name 51
#define SD_SERVER_ip_addr 52
/*
 ** Structure : SD_INFO
 **    Length : 288
 */
#define SD_INFO_sizelen 288
#define SD_INFO_sd_servers 0
#define SD_INFO_acmmaxretries 280
#define SD_INFO_acmbasetimeout 281
#define SD_INFO_acm_port 282
#define SD_INFO_query_limit 284
#define SD_INFO_encryption_mode 286
/*
 ** Structure : IPX_IF_STR
 **    Length : 38
 */
#define IPX_IF_STR_sizelen 38
#define IPX_IF_STR_Network 0
#define IPX_IF_STR_IfIndex 4
#define IPX_IF_STR_ConfigState 6
#define IPX_IF_STR_Protocol 7
#define IPX_IF_STR_RemoteNode 8
#define IPX_IF_STR_RIPBroadcast 14
#define IPX_IF_STR_SAPBroadcast 15
#define IPX_IF_STR_RIPTimer 16
#define IPX_IF_STR_SAPTimer 20
#define IPX_IF_STR_RIPDiscardTimeout 24
#define IPX_IF_STR_SAPDiscardTimeout 28
#define IPX_IF_STR_TransitDelay 32
#define IPX_IF_STR_ActualTransitDelay 34
#define IPX_IF_STR_ProtocolPriority 36
/*
 ** Structure : IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG
 **    Length : 10
 */
#define IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_sizelen 10
#define IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_network 0
#define IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_networkAll 4
#define IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_importExport 6
#define IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_allowDeny 7
#define IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_interface 8
/*
 ** Structure : IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG
 **    Length : 14
 */
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_sizelen 14
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_network 0
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_networkAll 4
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_importExport 6
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_allowDeny 7
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_interface 8
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_serviceType 10
#define IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_serviceTypeAll 12
/*
 ** Structure : IPX_PRM_SOURCE_DEST_FILTER_TAG
 **    Length : 34
 */
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_sizelen 34
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNetwork 0
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNetworkAll 4
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNode 6
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNodeAll 12
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_destNetwork 14
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_destNetworkAll 18
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_destNode 20
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_destNodeAll 26
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_forwardDiscard 28
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_packetType 29
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_packetTypeAll 30
#define IPX_PRM_SOURCE_DEST_FILTER_TAG_interface 32
/*
 ** Structure : IPX_STATIC_ROUTE_TAG
 **    Length : 16
 */
#define IPX_STATIC_ROUTE_TAG_sizelen 16
#define IPX_STATIC_ROUTE_TAG_interface 0
#define IPX_STATIC_ROUTE_TAG_network 2
#define IPX_STATIC_ROUTE_TAG_hops 6
#define IPX_STATIC_ROUTE_TAG_time 8
#define IPX_STATIC_ROUTE_TAG_forwardingRouter 10
/*
 ** Structure : IPX_STATIC_SERVICE_TAG
 **    Length : 66
 */
#define IPX_STATIC_SERVICE_TAG_sizelen 66
#define IPX_STATIC_SERVICE_TAG_name 0
#define IPX_STATIC_SERVICE_TAG_type 48
#define IPX_STATIC_SERVICE_TAG_network 50
#define IPX_STATIC_SERVICE_TAG_node 54
#define IPX_STATIC_SERVICE_TAG_socket 60
#define IPX_STATIC_SERVICE_TAG_hops 62
#define IPX_STATIC_SERVICE_TAG_interface 64
/*
 ** Structure : IP_FILTER_CHAR_STR_TAG
 **    Length : 40
 */
#define IP_FILTER_CHAR_STR_TAG_sizelen 40
#define IP_FILTER_CHAR_STR_TAG_dstAddr 0
#define IP_FILTER_CHAR_STR_TAG_dstMask 4
#define IP_FILTER_CHAR_STR_TAG_srcAddr 8
#define IP_FILTER_CHAR_STR_TAG_srcMask 12
#define IP_FILTER_CHAR_STR_TAG_dstPortStart 16
#define IP_FILTER_CHAR_STR_TAG_dstPortEnd 18
#define IP_FILTER_CHAR_STR_TAG_srcPortStart 20
#define IP_FILTER_CHAR_STR_TAG_srcPortEnd 22
#define IP_FILTER_CHAR_STR_TAG_intf 24
#define IP_FILTER_CHAR_STR_TAG_protocol 26
#define IP_FILTER_CHAR_STR_TAG_action 28
#define IP_FILTER_CHAR_STR_TAG_inUse 29
#define IP_FILTER_CHAR_STR_TAG_tcpSyn 30
#define IP_FILTER_CHAR_STR_TAG_protocolPriority 31
#define IP_FILTER_CHAR_STR_TAG_version 32
#define IP_FILTER_CHAR_STR_TAG_filler 33
/*
 ** Structure : CONTROLLED_P_INFO
 **    Length : 136
 */
#define CONTROLLED_P_INFO_sizelen 136
#define CONTROLLED_P_INFO_initPort 0
#define CONTROLLED_P_INFO_termPort 34
#define CONTROLLED_P_INFO_initSession 68
#define CONTROLLED_P_INFO_termSession 102
/*
 ** Structure : DOMAIN_PARAM_STR
 **    Length : 56
 */
#define DOMAIN_PARAM_STR_sizelen 56
#define DOMAIN_PARAM_STR_ip_addr 0
#define DOMAIN_PARAM_STR_name 4
/*
 ** Structure : KRB_P_INFO
 **    Length : 216
 */
#define KRB_P_INFO_sizelen 216
#define KRB_P_INFO_krb_realm 0
#define KRB_P_INFO_krb_master_name 41
#define KRB_P_INFO_krb_master_ipaddr 92
#define KRB_P_INFO_krb_server_name 96
#define KRB_P_INFO_krb_server_ipaddr 148
#define KRB_P_INFO_krb_server2_name 152
#define KRB_P_INFO_krb_server2_ipaddr 204
#define KRB_P_INFO_krbPwdPort 208
#define KRB_P_INFO_krb_passes 210
#define KRB_P_INFO_krb_port 212
#define KRB_P_INFO_fill2 214
/*
 ** Structure : XR_P_INFO
 **    Length : 118
 */
#define XR_P_INFO_sizelen 118
#define XR_P_INFO_xr_server_name 0
#define XR_P_INFO_xr_server_ipaddr 52
#define XR_P_INFO_xr_server2_name 56
#define XR_P_INFO_xr_server2_ipaddr 108
#define XR_P_INFO_xr 112
#define XR_P_INFO_fill 113
/*
 ** Structure : PARAM_PSERVER_STR
 **    Length : 128
 */
#define PARAM_PSERVER_STR_sizelen 128
#define PARAM_PSERVER_STR_this_port 0
#define PARAM_PSERVER_STR_pnumber 1
#define PARAM_PSERVER_STR_pserver 2
#define PARAM_PSERVER_STR_unused 51
/*
 ** Structure : PARAM_MSG_SEGMENT_STR
 **    Length : 8
 */
#define PARAM_MSG_SEGMENT_STR_sizelen 8
#define PARAM_MSG_SEGMENT_STR_type 0
#define PARAM_MSG_SEGMENT_STR_length 2
#define PARAM_MSG_SEGMENT_STR_count 4
#define PARAM_MSG_SEGMENT_STR_instance 6
/*
 ** Structure : ROUTE_PARAM_STR
 **    Length : 14
 */
#define ROUTE_PARAM_STR_sizelen 14
#define ROUTE_PARAM_STR_route_dest 0
#define ROUTE_PARAM_STR_route_mask 4
#define ROUTE_PARAM_STR_route_gate 8
#define ROUTE_PARAM_STR_route_flags 12
/*
 ** Structure : NETWORK_DEVICE_STR
 **    Length : 60
 */
#define NETWORK_DEVICE_STR_sizelen 60
#define NETWORK_DEVICE_STR_link 0
#define NETWORK_DEVICE_STR_dla 8
#define NETWORK_DEVICE_STR_type 14
#define NETWORK_DEVICE_STR_load_enabled 16
#define NETWORK_DEVICE_STR_dump_enabled 17
#define NETWORK_DEVICE_STR_node_name 18
#define NETWORK_DEVICE_STR_load_filename 34
#define NETWORK_DEVICE_STR_diag_filename 47
/*
 ** Structure : LPD_PARAM_STR
 **    Length : 46
 */
#define LPD_PARAM_STR_sizelen 46
#define LPD_PARAM_STR_name 0
#define LPD_PARAM_STR_ports 17
#define LPD_PARAM_STR_enabled 33
#define LPD_PARAM_STR_lfFilter 34
#define LPD_PARAM_STR_formfeed 35
#define LPD_PARAM_STR_bypass 36
#define LPD_PARAM_STR_fill 37
/*
** Useful Constants
*/
#define TBITS_PORT_LIST_SIZE 16
#define TBITS_GROUPS_SIZE 32			/* If changed, change same in valasm.68ki */
typedef unsigned long	ULONG;
#define VOID void
typedef VOID*			POINTER;
typedef unsigned long	LBITS;
typedef unsigned char	BOOLEAN;
typedef unsigned char	TBITS;
typedef char			TEXT;
typedef char			TINY;
typedef unsigned char	UTINY;
typedef short			COUNT;
typedef unsigned short	UCOUNT;
typedef ULONG	IPADDR;
#define DISABLED 0
#define ENABLED 1
#define REQUIRED	2
#define MAX_SERVER_PASSWORDS 20
#define TEXT_NAME_SIZE 17
#define TEXT_DOMAIN_NAME_SIZE (TEXT_NAME_SIZE*3)
#define LPD_NAME_SIZE                     TEXT_NAME_SIZE*2
#define FORMFEED_BEFORE                      1  /*  Send before job          */
#define FORMFEED_AFTER                       0  /*  Send after job (DEFAULT) */
#define FORMFEED_NONE                        2  /*  Send no formfeed         */
#define MAX_LOG_DEVICES 4
#define	MENU_DISPLAY_SIZE	31
#define MENU_COMMAND_SIZE	65
#define MENU_TEXT_SIZE 51
#define	MAX_MENU_ENTRIES	20
#define MENU_PROMPT_ENTRY	100
#define MENU_CONTINUE_ENTRY	101
#define	PSERVER_NAME_SIZE	49
#define TEXT_SET_IDENTIFICATION_SIZE 41
#define NODENAME_SIZE 16
#define FILENAME_SIZE 13    /* eight characters, dot, three characters, NULL */
#define TEXT_PASSWORD_SIZE 17
#define TEXT_CONNECT_ACTION_SIZE		64
#define	ROUTE_NETWORK			0x01
#define	ROUTE_HOST				0x02
#define ROUTE_FIXED				0x04
#define ROUTE_VARIABLE			0x08
#define ROUTE_LEARNED			0x010
#define SECURITY_INBOUND		0x01
#define SECURITY_OUTBOUND		0x02
#define SECURITY_ALLOW			0x01
#define SECURITY_DENY			0x02
#define SECURITY_ENABLED		0x01
#define SECURITY_DISABLED		0x02
#define SECURITY_REPLACE		0x00
#define MAX_SECURITY            100
#define MAX_DEFAULT_SECURITY    (TBITS_PORT_LIST_SIZE * sizeof (UTINY) * 8)
#define MAX_ROTARY_SERVICES     50
#define IPX_MAX_STATIC_ROUTES     50
#define IPX_MAX_STATIC_SERVICES   50
#define IPX_MAX_RIP_FILTERS       255
#define IPX_MAX_SAP_FILTERS       255
#define IPX_MAX_SRC_DEST_FILTERS  255
#define IP_MAX_FILTERS           100
#define BROADCAST_NONE       0
#define BROADCAST_CHANGE     1
#define BROADCAST_FULL       2
#define IPX_FILTER_IMPORT_EXPORT_NONE    0
#define IPX_FILTER_IMPORT                0x01
#define IPX_FILTER_IMPORT_EXPORT         0x03
#define IPX_FILTER_EXPORT                0x02
#define IPX_FILTER_FORWARD_DISCARD_NONE  0
#define IPX_FILTER_FORWARD               0x01
#define IPX_FILTER_FORWARD_DISCARD       0x03
#define IPX_FILTER_DISCARD               0x02
#define IP_TCP_SYN_OFF                                  0
#define IP_TCP_SYN_ON                                   1
#define IP_TCP_SYN_ALL                                  2
#define IP_PROTOCOL_ALL                                 256
#define UDP_ID			17			/* UDP protocol number */
#define TCP_ID		6			/* TCP protocol number */
#define PORT_ACCESS_NONE 0
#define PORT_ACCESS_DYNAMIC 1
#define PORT_ACCESS_LOCAL 2
#define PORT_ACCESS_REMOTE 3
#define PORT_ACCESS_PRT3270 4
#define PORT_SPEED_75 1
#define PORT_SPEED_110 2
#define PORT_SPEED_134 3
#define PORT_SPEED_150 4
#define PORT_SPEED_300 5
#define PORT_SPEED_600 6
#define PORT_SPEED_1200 7
#define PORT_SPEED_12000  22
#define PORT_SPEED_1800 8
#define PORT_SPEED_2000 9
#define PORT_SPEED_2400 10
#define PORT_SPEED_24000  25
#define PORT_SPEED_4800 11
#define PORT_SPEED_9600 12
#define PORT_SPEED_19200 13
#define PORT_SPEED_21600  27
#define PORT_SPEED_26400  28
#define PORT_SPEED_38400 14
#define PORT_SPEED_56000 15
#define PORT_SPEED_57600 16
#define PORT_SPEED_64000 17
#define PORT_SPEED_76800 18
#define PORT_SPEED_115000 19
#define PORT_SPEED_50     20
#define PORT_SPEED_7200   21
#define PORT_SPEED_12000  22
#define PORT_SPEED_14400  23
#define PORT_SPEED_16800  24
#define PORT_SPEED_24000  25
#define PORT_SPEED_28800  26
#define PORT_BREAK_DISABLED 0
#define PORT_BREAK_LOCAL 1
#define PORT_BREAK_REMOTE 2
#define PORT_FLOW_DISABLED 0
#define PORT_FLOW_CTS 1
#define PORT_FLOW_DSR 2
#define PORT_FLOW_XON 3
#define PORT_FLOW_XON_3M 6 /* N.Nichols 5/17/95 Displayed as "XON_ALT" */
#define PORT_FLOW_ENQH 4
#define PORT_FLOW_ENQT 5
#define PORT_DTRWAIT_DISABLED		0
#define PORT_DTRWAIT_ENABLED		1
#define PORT_DTRWAIT_FORCONNECTION	2
#define PORT_DTRWAIT_FORRING		3
#define PORT_PARITY_NONE 0
#define PORT_PARITY_EVEN 1
#define PORT_PARITY_MARK 2
#define PORT_PARITY_ODD 3
#define PORT_USERNAME_FILTER_NONE 0
#define PORT_USERNAME_FILTER_7BIT 1
#define PPP_LOG_NONE 0
#define PPP_LOG_RAW  1
#define PPP_LOG_COOKED 2
#define PPP_KERBEROS 0x02
#define PPP_RADIUS   0x03
#define APD_LOGOUT      0x0000
#define APD_ARAP        0x0001
#define APD_INTERACTIVE 0x0004
#define APD_SLIP        0x0008
#define APD_PPP         0x0010
#define APD_ALL         (APD_ARAP | /* APD_CSLIP |*/ APD_INTERACTIVE | APD_SLIP | APD_PPP)
#define TELNET_FLOW_PASTHRU	0
#define TELNET_FLOW_PASSALL	1
#define TELNET_FLOW_INTERACTIVE	2
#define PORT_TELNET_ECHO_LOCAL 0
#define PORT_TELNET_ECHO_REMOTE 1
#define PORT_TELNET_ECHO_DISABLED 2
#define PORT_TELNET_NEWLINE_NULL 0
#define PORT_TELNET_NEWLINE_LF 1
#define PORT_TELNET_NEWLINE_NOTHING 2
#define	PORT_TELNET_NEWLINE_FILTER_NONE	0
#define	PORT_TELNET_NEWLINE_FILTER_CR	1
#define	PORT_TELNET_NEWLINE_FILTER_LF	2
#define	PORT_TELNET_NEWLINE_FILTER_NULL	3
#define	PORT_TELNET_NEWLINE_FILTER_STD	4 /* RFC854 compliant - SAS 022592 */
#define PORT_TELNET_TRANSMIT_IMMEDIATE 0
#define PORT_TELNET_TRANSMIT_BUFFERED 1
#define PORT_TELNET_TRANSMIT_IDLE 2
#define SESSION_FLOW_INTERACTIVE 0	/* session flow */
#define SESSION_FLOW_INTERACTIVE_NOIAC 4 /* PTL 08/29/95 */
#define SESSION_FLOW_PASSALL	 1
#define SESSION_FLOW_PASTHRU	 2
#define SESSION_FLOW_TRANSPARENT 3
#define SESSION_LAT				1	/* LAT protocol */
#define	SESSION_LAT_QUEUED		6	/* queued connection */
#define SESSION_TELNET			2	/* TELNET */
#define SESSION_TELNET_MAINT	7	/* telnet session to maintenance port */
#define SESSION_TELNETLAT       13  /* either - TELNET first */ 
#define SESSION_LATTELNET		3	/* either - LAT first */
#define PORT_TELNET_TRANSMIT_IMMEDIATE 0
#define PORT_TELNET_TRANSMIT_BUFFERED 1
#define PORT_TELNET_TRANSMIT_IDLE 2
#define PORT_TYPE_ANSI 1
#define PORT_TYPE_HARDCOPY 2
#define PORT_TYPE_SOFTCOPY 3
#define DIALOUT_PROTOCOL_NONE	0x00
#define DIALOUT_PROTOCOL_QUERY	0x01
#define DIALOUT_PROTOCOL_SLIP	0x02
#define DIALOUT_PROTOCOL_PPP	0x03
#define XDMCP_QUERY_SPECIFIC	1
#define XDMCP_QUERY_BROADCAST	2
#define XDMCP_QUERY_INDIRECT	3
#define TN3278TYPE_MODEL2	5
#define TN3278TYPE_MODEL5	6
#define KEY_CMDS             70                /* number of keymap entries    */
#define KMAP_CODE_LEN    8                     /* maximum keymap code length  */
#define KMAP_DESC_LEN    5                     /* maximum keymap description  */
#define SCREEN_CMDS          24               /* number of screenmap entries */
#define SLINE_CMDS       2                     /* number of stat line pieces  */
#define RESET_CMDS       4                     /* number of reset cmd pieces  */
#define SMAP_CODE_LEN    9                     /* maximum screenmap code len  */
#define LSMAP_CODE_LEN   15                    /* maximum long smap code len  */
#define TN3270_ALTMAP_IND1  0x00    /* SRE-3M special value for desc[0] field of altmap key */
#define TN3270_ALTMAP_IND2  0x01    /* SRE-3M special value for desc[1] field of altmap key */
#define NVS_EN							0x00000001
#define MOP_EN							0x00000004
#define XMOP_EN							0x00000008
#define BOOTP_EN						0x00000010
#define RARP_EN							0x00000040
#define CARD_EN							0x00000100
#define DTFTP_EN						0x00000400
#define	ROM_CRATE_HW_MX1450	75
#define ROM_CRATE_HW_3M     88             /* 3M mx1450 OEM */
#define ROM_CRATE_HW_OSPREY  91             /* UBI OSPREY */
#define ROM_CRATE_HW_MX1608 78             /* 8 port 1600 */
#define ROM_CRATE_HW_MX1608A 		117     /* 8 port 1620 */
#define ROM_CRATE_HW_MX1608B 		119     /* 8 port 1620 (small size) */
#define LP_IMAGE	0
#define LP_PARAM	1
#define LP_DUMP		2
#define BOOT_RECORD_ENABLED 0x01
#define		MAX_SCRIPT_SERVERS	4
#define NLINK_IPADDR_FLAG 0xFFFF
#define PARAM_POLLING_ALL	1
#define PARAM_POLLING_TFTP	2
#define PARAM_POLLING_PROP	4
#define SNMP_COMMUNITY_TEXT_SIZE 33
#define SERVER_MAX_SNMP_CLIENTS      4
#define MAX_NETWORK_DEVICES 101
#define LOG_UNIX                   1		/* logging to UNIX host */
#define SOFTWARE_VERSION_TYPE_RELEASED 2
#define PRODUCT_COMM_SERVER         1
#define PRODUCT_COMM_SERVER_ONE_MEG 5
#define DES	2
#define SDIBC	1
#define	ACMMAXSERVERS	5
#define MAX_CONTROLLED_LEN		32
#define PARAM_SEGMENT_END_OF_LIST 0
#define PARAM_SEGMENT_SERVER_DATA 1
#define PARAM_SEGMENT_SERVICE_DATA 2
#define PARAM_SEGMENT_PORT_DATA 3
#define PARAM_SEGMENT_DOMAIN_DATA 4
#define PARAM_SEGMENT_ROUTE_DATA 5
#define PARAM_SEGMENT_LOAD_DATA 6
#define PARAM_SEGMENT_MANAGER_DATA 7
#define PARAM_SEGMENT_SCOPE_FILTER 8
#define PARAM_SEGMENT_SCOPE_TRIGGER 9
#define PARAM_SEGMENT_SCOPE_OUTREC 10
#define PARAM_SEGMENT_SECURITY_DATA 11
#define PARAM_SEGMENT_MENU_DATA 12
#define PARAM_SEGMENT_PARAM_SERVER_DATA 13
#define PARAM_SEGMENT_BRIDGE_DATA 14
#define PARAM_SEGMENT_FILTER_DATA 15
#define PARAM_SEGMENT_LINK_DATA 16
#define PARAM_SEGMENT_PROTOCOL_DATA 17
#define PARAM_SEGMENT_DEFAULT_SECURITY_DATA 18
#define PARAM_SEGMENT_KERBEROS_DATA 19
#define PARAM_SEGMENT_PASSWORD_DATA 20
#define PARAM_SEGMENT_TN3270_KEYMAP_DATA 21
#define PARAM_SEGMENT_ROTARY_DATA 22
#define PARAM_SEGMENT_TN3270_DEVICE_DATA 23
#define PARAM_SEGMENT_TN3270_XLAT_DATA 24
#define PARAM_SEGMENT_MENU_TEXT_DATA 25
#define PARAM_SEGMENT_X25GATE_DATA_1 30
#define PARAM_SEGMENT_X25GATE_DATA_2 31
#define PARAM_SEGMENT_SCRIPT_DATA 32
#define PARAM_SEGMENT_DIALBACK_DATA 33
#define PARAM_SEGMENT_XREMOTE_DATA  34
#define PARAM_SEGMENT_XPRINTER_DATA	35
#define PARAM_SEGMENT_NVS_DATA	36
#define PARAM_SEGMENT_LPD_DATA  37
#define PARAM_SEGMENT_SECURID_DATA  38
#define PARAM_SEGMENT_ARAP_SERVER_DATA  39
#define PARAM_SEGMENT_ARAP_PORT_DATA    40
#define PARAM_SEGMENT_SECURID_DATA  38
#define PARAM_SEGMENT_CONTROLLED_PORT_DATA 41
#define PARAM_SEGMENT_IPX_IF_DATA 42
#define PARAM_SEGMENT_IPX_STATIC_ROUTE_DATA 43
#define PARAM_SEGMENT_IPX_STATIC_SERVICE_DATA 44
#define PARAM_SEGMENT_IPX_RIP_FILTER          45
#define PARAM_SEGMENT_IPX_SAP_FILTER          46
#define PARAM_SEGMENT_IPX_ADDRESS_FILTER      47
#define PARAM_SEGMENT_IP_FILTER               48
#define PARAM_SEGMENT_PPP_DATA                49
#define PARAM_SEGMENT_CCL_DATA                50
#define PARAM_SEGMENT_KERB739_DATA            51
#define PARAM_SEGMENT_EXPANDED_PORT_DATA      52
#define PARAM_SEGMENT_RADIUS_DATA             53
#define PARAM_SEGMENT_SERVER_EXPANDED_DATA    54
#define PARAM_SEGMENT_SERVER_SNMP_EXP_DATA    55
#define PARAM_SEGMENT_UNKNOWN_FLAG 0x8000
#define PARAM_SEGMENT_UNKNOWN_MASK 0x7FFF
