/*$Id: utils.c,v 1.19 1996/03/19 17:48:25 faith Exp $*/
/*
 *****************************************************************************
 **         (C) Copyright 1993, Xyplex, Inc. All Rights Reserved.           **
 *****************************************************************************
 **                           u t i l s . c                                 **
 *****************************************************************************
 **                                                                         **
 **  Description :  This file contains the necessary supporting functions   **
 **                 for the apgen utility.                                  **
 **                                                                         **
 **  History     :  Who      What                                           **
 **  06//03/93      BJS/GJG  Original                                       **
 **                                                                         **
 *****************************************************************************
 */

#include "apgen.h"
#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>

char  tempString[120];
char  tempPortString[120];
extern int portNumber;
extern int arapPortNumber;
extern int controlledPortNumber;
extern int pppPortNumber;
extern int cclPortNumber;
extern int ipxInterfaceNumber;
extern int expandedPortNumber;
extern char *portTable[];
extern char *arapPortTable[];
extern char *ipxInterface[];
extern char *controlledPortTable[];
extern char *pppPortTable[];
extern char *cclPortTable[];
extern char *expandedPortTable[];
extern char  portBits[];
extern int   ipxEnabled;
PLISTNODE PlistValueInList();
void      FillPlistNode();
int       VersionLaterOrEqual();
int       ProductSupportsIndex();
void      GenerateCondensedPortInfo();
void      GenerateVerbosePortInfo();
extern unsigned char  SoftwareVersionMajor;
extern unsigned char  SoftwareVersionMinor;
extern unsigned char  SoftwareVersionEco;
extern unsigned char  SoftwareVersionType;
extern unsigned char  SoftwareVersionPrerelease;
extern unsigned char  SoftwareProduct;
extern unsigned int   HardwareType;
extern int OneMegProduct();
extern unsigned int   pppParamsSeen;
extern unsigned int   cclParamsSeen;
extern void PrintPortCCLData();
extern void PrintPortOldCCLData();
extern void PrintPortPPPData();
extern void PrintPortOldPPPData();

/*
 ** ClockDate2Text()
 ** 
 **    Converts date in "clock" format to a character string.  Stolen from
 **    clock.c / clock_dat2txt().
 **
 ** Arguments:
 **
 **    date  - Date, format is YYYY MM DD, bits 31 - 0
 **
 **    text  - pointer to results location
 */

char *monthsText[16] = { "???", "Jan", "Feb", "Mar", "Apr",
			     "May", "Jun", "Jul", "Aug",
			     "Sep", "Oct", "Nov", "Dec", 
			     "???", "???", "???" };
 
void ClockDate2Text( date, text )
     int       date;
     char     *text;
{
    sprintf( text, "%02u %3s %04u",
	    date & 0xFF,
	    monthsText[ (date >> 8) & 0xF ],
	    (date >> 16) & 0xFFFF );
    }


/*
 ** ClockTime2Text()
 **
 **    Converts time in "clock" format to a character string.  Stolen from
 **    clock.c / clock_tim2txt().
 **
 ** Arguments:
 **
 **    time - Time, format is 00 HH MM SS, bits 31 - 0
 **
 **    text - pointer to results location
 **
 */
void ClockTime2Text( time, text )
     int       time;
     char     *text;
{
    sprintf( text, "%02u:%02u:%02u",
	    (time >> 16) & 0xFF,
	    (time >> 8) & 0xFF,
	    time & 0xFF );
    }

/*
 ** int VersionLaterOrEqual ( major, minor, eco, type, prerelease)
 ** 
 ** This routine will determine if the specified version is equal or later
 ** than the given parameter file software version.
 **
 ** Args
 ** 
 ** major - Major software revision that the functionality is supported in
 ** minor - Minor version that the software functionality is supported in
 **
 ** Returns
 **   TRUE  - if version of parameter file is equal or greater than
 **           the version passed in.
 **   FALSE - otherwise.
 */

int VersionLaterOrEqual ( vMajor, vMinor, vEco, vType, vPrerelease)
     unsigned char vMajor;
     unsigned char vMinor;
     unsigned char vEco;
     unsigned char vType;
     unsigned char vPrerelease;
{
    /*
     ** There will always be a major and a minor number at least.
     ** there may not always be an eco, special, or prerelease number.
     */
     
    if (SoftwareVersionMajor < vMajor)
	{
	return (FALSE);
	}
    /*
     ** We are now greater than or equal to the major number
     */
    if ((SoftwareVersionMajor == vMajor) &&	/*fbs 081895 SC62403 */
       (SoftwareVersionMinor < vMinor))
	{
	return (FALSE);
	}
    
    if (vEco != (unsigned char) VERSION_DONT_CARE)
	{
    if ((SoftwareVersionMajor == vMajor) 	/*fbs 081895 SC62403 */
         && (SoftwareVersionMinor == vMinor)    /*fbs 081895 SC62403 */    	
	 && (SoftwareVersionEco < vEco))
	    {
	    return (FALSE);
	    }
	}

    if (vType != (unsigned char) VERSION_DONT_CARE)
	{
	/*
	 ** if the actual type is less than vType then it is not supported in 
	 ** this version.
	 ** the Type is ordered ie. ALPHA, BETA, RELEASE, SPECIAL.
	 */
    if ((SoftwareVersionMajor == vMajor)        /*fbs 081895 SC62403 */
         && (SoftwareVersionMinor == vMinor)    /*fbs 081895 SC62403 */
	 && (SoftwareVersionEco == vEco)        /*fbs 081895 SC62403 */ 
	 && (SoftwareVersionType < vType))
	    {
	    return (FALSE);
	    }
	/*
	 ** If we're here, the type is later, now we need to check the 
	 ** prerelease number.
	 */
    if ((SoftwareVersionMajor == vMajor)      /*fbs 081895 SC62403 */
         && (SoftwareVersionMinor == vMinor)  /*fbs 081895 SC62403 */
	 && (SoftwareVersionEco == vEco)      /*fbs 081895 SC62403 */
	 && (SoftwareVersionType == vType)    /*fbs 081895 SC62403 */
	 && (SoftwareVersionPrerelease < vPrerelease))
	    {
	    return (FALSE);
	    }
	}
    

    /*
     ** If we get here, the parametr file version is equal or later
     ** than the versions specified
     */
    return (TRUE);
    }

/*
 ** int VersionLater ( major, minor, eco, type, prerelease)
 ** 
 ** This routine will determine if the specified version is later
 ** than the given parameter file software version.
 **
 ** Args
 ** 
 ** major - Major software revision that the functionality is supported in
 ** minor - Minor version that the software functionality is supported in
 **
 ** Returns
 **   TRUE  - if version of parameter file is greater than
 **           the version passed in.
 **   FALSE - otherwise.
 */

int VersionLater ( vMajor, vMinor, vEco, vType, vPrerelease)
     unsigned char vMajor;
     unsigned char vMinor;
     unsigned char vEco;
     unsigned char vType;
     unsigned char vPrerelease;
{
    /*
     ** There will always be a major and a minor number at least.
     ** there may not always be an eco, special, or prerelease number.
     */
     
    if (SoftwareVersionMajor > vMajor)
	{
	return (TRUE);
	}
    /*
     ** We are now less than or equal to the major number
     */
    if ((SoftwareVersionMajor == vMajor)		/*fbs 081895 SC62403*/
       && (SoftwareVersionMinor > vMinor))
	{
	return (TRUE);
	}
    
    if (vEco != (unsigned char) VERSION_DONT_CARE)
	{
	if ((SoftwareVersionMajor == vMajor)	
            && (SoftwareVersionMinor == vMinor)
	    && (SoftwareVersionEco > vEco))
	    {
	    return (TRUE);
	    }
	}

    if (vType != (unsigned char) VERSION_DONT_CARE)
	{
	/*
	 ** if the actual type is greater than vType then it is not supported in 
	 ** this version.
	 ** the Type is ordered ie. ALPHA, BETA, RELEASE, SPECIAL.
	 */
	if ((SoftwareVersionMajor == vMajor)	
            && (SoftwareVersionMinor == vMinor)
	    && (SoftwareVersionEco == vEco)
	    && (SoftwareVersionType > vType))
	    {
	    return (TRUE);
	    }
	/*
	 ** If we're here, the type matches or earlier, now we need to check
	 ** prerelease number.
	 */

	if ((SoftwareVersionMajor == vMajor)	
           && (SoftwareVersionMinor == vMinor)
	   && (SoftwareVersionEco == vEco)
	   && (SoftwareVersionType == vType)
	   && (SoftwareVersionPrerelease > vPrerelease))
	    {
	    return (TRUE);
	    }
	}
    

    /*
     ** If we get here, the parameter file version is earlier or equal
     ** to the version specified
     */
    return (FALSE);
    }

/*
 ** ProductSupportsIndex( index )
 **
 ** This routine will return an error if the INDEX_... is not supported by the 
 ** given software product.  This routine can be used only for PORT 
 ** information that is set up in a port index table.
 */

int ProductSupportsIndex( index )
     int index;
{
    if ((OneMegProduct()) && 
	((index == INDEX_NESTED_MENU) || (index == INDEX_XREMOTE) ||
	 (index == INDEX_PPP) || (index == INDEX_ARAP) || 
	 (index == INDEX_CCL) || (index == INDEX_CONTROLLED_PORT) ||
	 (index == INDEX_SECURID)))
	{
	return (FALSE);
	}

    if ((index == INDEX_IPX_INTERFACE) && (!ipxEnabled))
	{
	return (FALSE);
	}
    
    /*
     ** Just about everything is supported by everything, so we'll always 
     ** return true.  If there are any INDEXes that are not supported by 
     ** a product for any reason, put them before this return.
     */

    return (TRUE);

    } /* End of ProductSupportsIndex() */


/*
 ** HardwareSupportsIndex( index )
 **
 ** This routine will return an error if the INDEX_... is not supported by the 
 ** given hardware type.  
 */

int HardwareSupportsIndex( index )
     int index;
{
    if ((index == INDEX_CONTROLLED_PORT) && 
	((HardwareType == ROM_CRATE_HW_MX1450) ||
	 (HardwareType == ROM_CRATE_HW_3M)))
	{
	return (FALSE);
	}

    /*
     ** Just about everything is supported by everything, so we'll always 
     ** return true.  If there are any INDEXes that are not supported by 
     ** a hardware platform for any reason, put them before this return.
     */

    return (TRUE);

    } /* End of HardwareSupportsIndex() */

/*
 ** OneMegProduct()
 **
 ** This routine returns true if the parameter file is a ONE meg image
 */ 
int OneMegProduct()
{
    return (SoftwareProduct == PRODUCT_COMM_SERVER_ONE_MEG);
    } /* End OneMegProduct() */

/*
 ** int ArapSuppported ()
 ** 
 ** This routine will determine if the arap functionality is supported by the
 ** parameter file revision.
 **
 ** Returns
 **
 ** TRUE  - This version supports ARAP.
 ** FALSE - otherwise.
 */

int ArapSupported ( )
{
    return (VersionLaterOrEqual( 5, 2, VERSION_DONT_CARE,
				VERSION_DONT_CARE, VERSION_DONT_CARE));
    }

/*
 ** int SupportedVersion_5_2 ()
 ** 
 ** This routine will determine if the functionality is supported by the
 ** parameter file revision.
 **
 ** Returns
 **
 ** TRUE  - This version supports this functionality.
 ** FALSE - otherwise.
 */

int SupportedVersion_5_2( )
{
    return (VersionLaterOrEqual( 5, 2, VERSION_DONT_CARE,
				VERSION_DONT_CARE, VERSION_DONT_CARE));
    }

/* OurBCopy()
 **
 ** Byte copy from s1 to s2 for len.
 */
 
void OurBCopy(s1, s2, len)
     char *s1, *s2;
     int  len;
{
    int i;
 
    for (i=0; i<len; i++)
        {
        *s2++ = *s1++;
        }
    }

/* ByteCmp()
 **
 ** Byte compare s1 to s2 for len.
 */
 
int ByteCmp(s1, s2, len)
     char *s1, *s2;
     int  len;
{
    int i;
 
    for (i=0; i<len; i++)
        {
        if (*s2++ != *s1++)
	    return (1);
        }
    return (0);
    }
/*
 ** IpToString()
 **
 **    Converts an IP address to a string.
 **
 ** Arguments:
 **
 **    ipAddr   - IP address, binary form.
 **
 **    text     - pointer to results location.
 **
 */

void IpToString( ipAddr, text )
     unsigned long    ipAddr;
     char            *text;
     
{
    sprintf(text, "%u.%u.%u.%u",
            (ipAddr >> 24) & 0xFF,
            (ipAddr >> 16) & 0xFF,
            (ipAddr >>  8) & 0xFF,
            (ipAddr & 0xFF ));
    }

/*
 ** AlignAndConvertIpAddr()
 **
 **    Aligns an IP address on a 32 bit boundary and then converts it to
 **    a string.
 **
 ** Arguments:
 **
 **    data - pointer to IP address (unaligned)
 */
 
char *AlignAndConvertIpAddr( data )
     char *data;
{
    int temp;
   
    temp = GetDoubleWord( data );
    IpToString( temp, tempString );
    return( tempString );
    }

/*
 ** AlignAndConvertEthAddr()
 **
 **    Aligns an Ethernet address and converts it to a string, if the first
 **    word of this is NLINK_IPADDR_FLAG, then it returns the IP address.
 **
 ** Arguments:
 **
 **    data - pointer to Ethernet address 
 */
 
char *AlignAndConvertEthAddr( data )
     char *data;
{
    unsigned short ethAddr[3];
    unsigned long  ipAddr;

    ethAddr[0] = GetWord((char *) &data[0] );
    if(ethAddr[0] == NLINK_IPADDR_FLAG)
	{
	ipAddr = GetDoubleWord((char *) &data[2]);
	IpToString( ipAddr, tempString );
	return( tempString );
	}
    else
	{
	ethAddr[1] = GetWord((char *) &data[2]);
	ethAddr[2] = GetWord((char *) &data[4]);
	}
    
    sprintf(tempString,"%02x-%02x-%02x-%02x-%02x-%02x",
	    (ethAddr[0] >> 8) & 0xFF,
	    (ethAddr[0]) & 0xFF,
	    (ethAddr[1] >> 8) & 0xFF,
	    (ethAddr[1]) & 0xFF,
	    (ethAddr[2] >> 8) & 0xFF,
	    (ethAddr[2]) & 0xFF);
    return( tempString );
}

/*
 ** AlignAndConvertEthAddr()
 **
 **    Aligns an Ethernet address and converts it to a string, if the first
 **    word of this is NLINK_IPADDR_FLAG, then it returns the IP address.
 **
 ** Arguments:
 **
 **    data - pointer to Ethernet address 
 */
 
char *ConvertIpxNodeAddr( data )
     char *data;
{
    unsigned short ethAddr[3];
    unsigned long  ipAddr;

    ethAddr[0] = GetWord((char *) &data[0] );
    if(ethAddr[0] == NLINK_IPADDR_FLAG)
	{
	ipAddr = GetDoubleWord((char *) &data[2]);
	IpToString( ipAddr, tempString );
	return( tempString );
	}
    else
	{
	ethAddr[1] = GetWord((char *) &data[2]);
	ethAddr[2] = GetWord((char *) &data[4]);
	}
    
    sprintf(tempString,"%02X%02X%02X%02X%02X%02X",
	    (ethAddr[0] >> 8) & 0xFF,
	    (ethAddr[0]) & 0xFF,
	    (ethAddr[1] >> 8) & 0xFF,
	    (ethAddr[1]) & 0xFF,
	    (ethAddr[2] >> 8) & 0xFF,
	    (ethAddr[2]) & 0xFF);
    return( tempString );
}

/*
 ** SingleCharToString()
 **
 ** Stuffs a single character into a string.
 **
 ** Arguments
 **
 ** data - A pointer to the character
 */

char *SingleCharToString( data )
     char *data;
{
    tempString[0] = data[0];
    tempString[1] = '\0';
    return (tempString );
    }

/*
 ** IsPortZeroOnlyOne()
 */

int IsPortZeroOnlyOne( ports)
     char *ports;
{
    int loop;
    int otherPort = FALSE;
    
    for (loop = 1; loop < portNumber; loop++)
	{
	if (TST_ARRAY_BIT(ports, loop))
	    {
	    otherPort = TRUE;
	    }
	}
    return ((otherPort == FALSE) && TST_ARRAY_BIT(ports, PORT_ZERO));
}

/*
 ** ListToString()
 **
 **    Converts a group or port list (array) to a string.
 **
 **    ports    - pointer to port list
 **
 **    text     - pointer to results location.
 **               will contain a null string if no port list
 **
 **    max      - maximum bits to step through
 **
 **    portOrGroup - flag indicating group list or port list
 **
 */

ListToString( ports, text , max, portOrGroup)
     char   *ports;
     char   *text;
     int     max;
     int     portOrGroup;
{
    unsigned char needComma = 0;
    int           i, sequence = 0;    
    char         *bufferPtr;
    int           all = TRUE;
    
    bufferPtr = text;
    *bufferPtr = '\0';
    
    for (i = 0; i<max; i++)
	{
	if (((TST_ARRAY_BIT( ports, i )) && (i != max-1)) ||
	    (TST_ARRAY_BIT( ports, i) && (i == max-1) && 
	     ((sequence == 0) || (sequence == 1))))
	    {
	    if (needComma)
		{
		if(sequence++ == 0)
		    {
		    sprintf( bufferPtr, ", %d", i);
		    bufferPtr = text + strlen(text);
		    }
		else if (( i == max-1) && (sequence == 2))
		    {
		    sprintf( bufferPtr, "-%d", i);
		    bufferPtr = text + strlen(text);
		    sequence = 0;
		    }
		}
	    else
		{
		sprintf( bufferPtr, "%d", i);
		bufferPtr = text + strlen(text);
		needComma = 1;
		sequence++;
		}
	    }
	else
	    {
	    if((sequence != 0) && (sequence != 1) &&
	       (i == max-1) && TST_ARRAY_BIT(ports,i))
		{
		sprintf(bufferPtr, "-%d", i);
		bufferPtr = text + strlen(text);
		sequence = 0;
		}
	    if((sequence != 0) && (sequence != 1))
		{
		sprintf(bufferPtr, "-%d", (i-1));
		bufferPtr = text + strlen(text);
		sequence = 0;
		}
	    else 
		{
		sequence = 0;
		}
	    if ( !TST_ARRAY_BIT(ports, i))
		{
		all = FALSE;
		if ((portOrGroup == PORT) && (i == PORT_ZERO))
		    {
		    /* port zero doesn't  count for ALL in a port list */
		    all = TRUE;
		    }
		}

	    }
	}

    if (all == TRUE) 
	{
            /* Don't use 'ALL' if port zero included in list ***fbs 053195 */
            if ((portOrGroup == PORT) && (TST_ARRAY_BIT(ports, PORT_ZERO)))
            {
                all = FALSE;
            }
            else
            {
	        bufferPtr = text;
	        sprintf(bufferPtr, "ALL");
            }
        }
}

/*
 ** PortListToString()
 **
 **    Converts a port list (array) to a string.
 **
 **    ports    - pointer to port list
 **
 **    text     - pointer to results location.
 **               will contain a null string if no port list
 **
 */
PortListToString( ports, text)
     char   *ports;
     char   *text;
{
    ListToString( ports, text, portNumber, PORT);
    }

/*
 ** PListToString ( plist)
 **
 ** portList - pointer to port list 
 */
char *PListToString( plist)
     char *plist;
{
    PortListToString( plist, tempPortString);
    return (tempPortString);
}

/*
 ** GroupListToString()
 **
 **    Converts a group list (array) to a string.
 **
 **    ports    - pointer to port list
 **
 **    text     - pointer to results location.
 **
 */
GroupListToString( groups, text)
     char   *groups;
     char   *text;
{
    ListToString( groups, text, TBITS_GROUPS_SIZE * 8, GROUP);
    }

/*
 ** GroupListEqual ( group1, group2)
 ** 
 ** returns TRUE if group1 and group2 are equal
 */

int GroupListEqual ( group1, group2)
     char group1[];
     char group2[];
{
    int loop;
    int equal = TRUE;
    
    for (loop=0; loop < (TBITS_GROUPS_SIZE * 8); loop++)
	{
	/*
	 ** If a bit in group1 is set when one in group2 is not, or vice 
	 ** versa, then the lists are not equal.
	 */
	if ((!TST_ARRAY_BIT( group1, loop) && TST_ARRAY_BIT( group2, loop)) ||
	    (TST_ARRAY_BIT( group1, loop) && !TST_ARRAY_BIT( group2, loop)))
	    {
	    equal = FALSE;
	    }
	}
    return (equal);
}

/*
 ** GroupListcopy ( dest, source)
 ** 
 ** copies source group list to dest grouplist
 */

void GroupListCopy ( dest, source)
     char *dest;
     char *source;
{
    int loop;
    
    for (loop=0; loop < (TBITS_GROUPS_SIZE * 8); loop++)
	{
	if (TST_ARRAY_BIT( source, loop))
	    {
	    bits_set( dest, loop, loop);
	    }
	else
	    {
	    bits_clear( dest, loop, loop);
	    }
	}
}

/*
 ** ControlledPortsEqual ( controlledPort1, controlledPort2)
 ** 
 ** returns TRUE if port1 and port2 are equal
 */

int ControlledPortsEqual ( controlledPortOne, controlledPortTwo)
     char controlledPortOne[];
     char controlledPortTwo[];
{
    int loop;
    int portOneLength, portTwoLength;
    int equal = TRUE;
    
    /*
     ** The controlled port structures look as follows:
     ** first byte - length of hex bytes.
     ** MAX_CONTROLLED_LEN bytes follow - not all used.
     */
    portOneLength = *controlledPortOne;
    portTwoLength = *controlledPortTwo;
    
    if (portOneLength != portTwoLength)
	{
	/*
	 ** These are not equal, we can not have a match.
	 */
	return (FALSE);
	}
    
    
    for (loop=1; loop <= portOneLength; loop++)
	{
	/*
	 ** If a byte in port1 does not equal the one in group2 
	 ** then we do not have a match, and we're outta here.
	 */
	if (controlledPortOne[loop] != controlledPortTwo[loop])
	    {
	    return (FALSE);
	    }
	}
    return (equal);
} /* End of ControlledPortsEqual() */

/*
 ** ControlledPortsCopy ( dest, source)
 ** 
 ** copies source controlled port  to dest controlled port
 */

void ControlledPortsCopy ( dest, source)
     char *dest;
     char *source;
{
    int loop;
    
    for (loop=0; loop < (MAX_CONTROLLED_LEN + 1); loop++)
	{
	dest[loop] = source[loop];
	}
}

/*
 * AsciiToHex( data, string, length )
 * 
 * data - pointer to individual structure, 1st byte is length of the string
 */

char *AsciiToHex( data )
     char *data;
{
    int loop;
    int length;
    char *bufferPtr;
    
    length = *data;         /* get the length */
    bufferPtr = tempString;
    *bufferPtr = '\0';
    if (!(*data))
	{
	sprintf( bufferPtr, "");
	return;
	}
    
    for (loop = 1; (loop < length+1); loop++)
	{
	if(loop != 1)
	    {
	    /* Don't want a leading space */
	    sprintf(bufferPtr," ");
	    bufferPtr = tempString + strlen(tempString);
	    }	    
	sprintf(bufferPtr,"%02X", (data[loop] & 0xFF));
	bufferPtr = tempString + strlen(tempString);
	}
    return (tempString);
}

/*
 ** PrintLoadDumpProtocols()
 **
 ** Arguments
 **
 ** string - the string to print before it.
 ** ld - Character pointer to the loaddump flag word
 */

void PrintLoadDumpProtocols( loadDumpString, ld )
     char *loadDumpString;
     char *ld;
{
    static int protocolMask[] =
	{
	CARD_EN, DTFTP_EN, NVS_EN, XMOP_EN, MOP_EN, BOOTP_EN, RARP_EN
	};
    
    static char *protocolString[] =
	{
	"CARD", "DTFTP", "NVS", "XMOP", "MOP", "BOOTP", "RARP"
	};
    
    unsigned int loaddump;
    int loop;
    int protocolsSupported = 7;

    loaddump = GetDoubleWord((char *) ld);
    for (loop = 0; loop < protocolsSupported; loop++)
	{
	if (loaddump & protocolMask[loop])
            {  
	    printf("%s", loadDumpString);
	    printf("%s ENABLED\n", protocolString[loop]);
	    }
	}
}
  


/*
 * Tn3270KeyToHex( data, string, length )
 * 
 * data - pointer to individual KMAP, SMAP, or LSMAP structure
 *        They are all the same structure, 1st byte is length of next string
 * string - character array to stor result in
 * length - that the key may be
 */

char *Tn3270KeyToHex( data, string, length )
     char *data;
     char * string;
     int length;
{
    int loop;
    char *bufferPtr;
    
    bufferPtr = string;
    if (!data[KMAP_len])
	{
	sprintf( bufferPtr, "");
	return;
	}
    
    for (loop = 0; ((loop < length) && (loop <*data)); loop++)
	{
	if(loop != 0)
	    {
	    /* Don't want a leading space */
	    sprintf(bufferPtr," ");
	    bufferPtr = string + strlen(string);
	    }	    
	sprintf(bufferPtr,"%02X", (data[KMAP_code + loop] & 0xFF));
	bufferPtr = string + strlen(string);
	}
}

/*
 ** TN3270DeviceIsOurDevice()
 ** 
 ** Arguments
 ** 
 ** device - a character string containing the device name.
 */
int TN3270DeviceIsOurDevice( device )
     char *device;
{
    static char *ourDevices[] = 
	{
	"ANSI", "VT100", "VT220-7", "VT220-8", ""
	    };
    int loop = 0;

    while(strcmp(ourDevices[loop], "") != 0)
	{
	if (strcmp( device, ourDevices[loop]) == 0)
	    {
	    return TRUE;
	    }
	loop++;
	}
    }

/*
 ** GetByte()
 **
 */
unsigned char GetByte( data )
     char *data;
 
{
    unsigned char   temp;
 
    OurBCopy( (char *)data, (char *)&temp, 1 );
    return( temp );
    }

/*
 ** GetWord()
 **
 */
int GetWord( data )
     char *data;
 
{
    unsigned short temp, temp2;
 
    OurBCopy( (char *)data, (char *)&temp, 2 );
    temp2 = htons (temp);
    return( temp2 );
    }

/*
 ** GetDoubleWord()
 */
int GetDoubleWord( data )
     char *data;
 
{
    unsigned long temp, temp2;
 
    OurBCopy( (char *)data, (char *)&temp, 4 );
    temp2 = htonl ( temp );
    return( temp2 );
    }

bits_set( bit_map, start, end )
     TBITS                             *bit_map;
     COUNT                             start;
     COUNT                             end;
{
    COUNT                      tmp;
    
    if (start > end)
        {
	tmp = start;
	start = end;
	end = tmp;
        }
    for ( ; start <= end; start++ )
        {
	bit_map[ start / 8 ] |= (1 << (start % 8));
        }
 }

bits_clear( bit_map, start, end )
     TBITS                             *bit_map;
     COUNT                             start;
     COUNT                             end;
{
    COUNT                      tmp;
    
    if (start > end)
        {
	tmp = start;
	start = end;
	end = tmp;
        }
    for ( ; start <= end; start++ )
        {
	bit_map[ start / 8 ] &= ~(1 << (start % 8));
        }
}

/*
 ** PlistInit( plist )
 **
 ** Arguments 
 ** 
 ** plist - pointer to structure of type PLIST
 */

void PlistInit( plist )
     PLIST *plist;
{
    plist->head = NULL_VALUE;
    plist->tail = NULL_VALUE;
}

/*
 ** PlistFree( plist )
 **
 ** Arguments 
 ** 
 ** plist - pointer to structure of type PLIST
 */

void PlistFree( plist )
     PLIST *plist;
{
    PLISTNODE nodePtr, nextNodePtr;
    
    nodePtr = plist->head;
    while(nodePtr != NULL_VALUE)
	{
	nextNodePtr = nodePtr->next;
	free(nodePtr);
	nodePtr = nextNodePtr;
	}
    PlistInit( plist);
}

/*
 ** PlistEmpty (list)
 ** returns true if the list is empty
 */
int PlistEmpty( list )
     PLIST  *list;
{
    return ((list->head == NULL_VALUE) && (list->tail == NULL_VALUE));
}

/*
 ** AddPlistNode (list)
 **
 ** funtion returns a pointer to the added node (nodes are added to the end.)
 */
PLISTNODE AddPlistNode ( list)
     PLIST *list;
{
    PLISTNODE nodePtr;
    
    nodePtr = (PLISTNODE) malloc(sizeof(struct plistnode));
    bits_clear(nodePtr->portList, 0, (TBITS_PORT_LIST_SIZE *8)-1);
    nodePtr->next = NULL_VALUE;
    if (PlistEmpty(list))
	{
	list->head = nodePtr;
	list->tail = nodePtr;
	}
    else
	{
	list->tail->next = nodePtr;
	list->tail = nodePtr;
	}	
    return nodePtr;
}    

/*
 ** AddPlistNodeToHead (list)
 **
 ** funtion returns a pointer to the added node (nodes are added to the head.)
 */
PLISTNODE AddPlistNodeToHead ( list)
     PLIST *list;
{
    PLISTNODE nodePtr;
    
    nodePtr = (PLISTNODE) malloc(sizeof(struct plistnode));
    bits_clear(nodePtr->portList, 0, (TBITS_PORT_LIST_SIZE *8)-1);
    if (PlistEmpty(list))
	{
	list->head = nodePtr;
	list->tail = nodePtr;
	nodePtr->next = NULL_VALUE;
	}
    else
	{
	nodePtr->next = list->head;
	list->head = nodePtr;
	}	
    return nodePtr;
}    

/*
 ** AddPortToPlist( list, portPtr, port, offset, type, headOrTail)
 **
 ** This routine will add a node to list, or set the appropriate port bit
 ** in an existing node in list whose value matches offsets.
 **
 ** ARGUMENTS:
 ** 
 ** list - a list of nodes to add the node to if a value is not found in 
 **        any of the existing nodes.
 **
 ** portPtr - pointer to port structure that offset is to be gotten from
 ** 
 ** port - This is the port number.
 **
 ** offset - Offset that will contain value to check for
 **
 ** type - This is the type of value that offset will contain.
 **        see plistnode structure in apgen.h
 ** 
 ** headOrTail - tells wether we need to add the node to the head or tail
 **/
void AddPortToPlist(list, portPtr, port, offset, type, headOrTail)
     PLIST  *list;
     char   *portPtr;
     int     port;
     int     offset;
     int     type;
     int     headOrTail;
{
    PLISTNODE nodePtr;
    
    /*
     ** Step through list, if value matches set appropriate portbit.
     ** else add another item to the list.
     ** If NULL_VALUE is returned, we have to add this node to the list.
     */

    nodePtr = (PLISTNODE) PlistValueInList( list, portPtr, port, offset, type);
    if (nodePtr != NULL_VALUE)
	{
	bits_set(nodePtr->portList, port, port);
	}
    else
	{
	if (headOrTail == ADD_TO_HEAD)
	    {
	    nodePtr = AddPlistNodeToHead( list);
	    }
	else  /* just add it to the tail */
	    {
	    nodePtr = AddPlistNode( list);
	    }	    
	FillPlistNode( nodePtr, portPtr, port, offset, type);
	}
}
 	
/*
 ** PlistValueInList( list, portPtr, port, offset, type)
 **
 ** ARGUMENTS:
 ** 
 ** list - a list of nodes to search through
 **
 ** portPtr - pointer to port structure that offset is to be gotten from
 ** 
 ** port - This is the port number.
 **
 ** offset - Offset that will contain value to check for
 **
 ** type - This is the type of value that offset will contain.
 **        see plistnode structure in apgen.h
 **
 ** RETURNS:
 ** returns a pointer to the node who matches the value, or NULL_VALUE if no match
 */

PLISTNODE PlistValueInList( list, portPtr, port, offset, type)
     PLIST  *list;
     char   *portPtr;
     int    port;
     int    offset;
     int    type;
{
    PLISTNODE currentNode, NodePtr;
    int match = FALSE;
    unsigned long tempLong;
    unsigned short tempWord;
    
    currentNode = list->head;
    
    while((currentNode != NULL_VALUE) && (match == FALSE))
	{
	switch (type)
	    {
	case INTEGER_VALUE:
	    {
	    tempLong = GetDoubleWord( portPtr + offset);
	    if(currentNode->type.iValue == htonl(tempLong))
		{
		match = TRUE;
		}
	    break;
	    }
	    
	case SHORT_INT_VALUE:
	    {
	    tempWord = GetWord( portPtr + offset);
	    if(currentNode->type.siValue == (unsigned short) tempWord)
		{
		match = TRUE;
		}
	    break;
	    }
	case CHAR_VALUE:
	    {
    	    if(currentNode->type.cValue == GetByte( portPtr + offset))
	       {
		match = TRUE;
		}
	    break;
	    }
	case CHAR_PTR_VALUE:
	    {
	    if(strcmp(currentNode->type.pcValue, 
		      (char *) (portPtr + offset)) == 0)
		{
		match = TRUE;
		}
	    break;
	    }
	case GROUP_VALUE:
	    {
	    if (GroupListEqual(currentNode->type.gValue, 
			       (char *) ( portPtr + offset)))
		{
		match = TRUE;
		}
	    break;
	    }
	case CTRL_PORT_VALUE:
	    {
	    if (ControlledPortsEqual(currentNode->type.ctrlpValue, 
			       (char *) ( portPtr + offset)))
		{
		match = TRUE;
		}
	    break;
	    }
	case CHAR_EIGHT_VALUE:
	    {
	    if (strncmp (currentNode->type.chr8Value, (char *) (portPtr + offset), 8) == 0)
		{
		match = TRUE;
		}
	    break;
	    }
	case ETHERNET_VALUE:
	    {
	    if (ByteCmp(currentNode->type.ethValue, (char *) (portPtr + offset), 6) == 0)
		{
		match = TRUE;
		}
	    break;
	    }

	    }


	if (match == TRUE)
	    {
	    return (currentNode);
	    }
	currentNode = currentNode->next;
	} /* end while */
    
    return NULL_VALUE;

}

/*
 ** FillPlistNode( node, portPtr, port, offset, type)
 **
 ** ARGUMENTS:
 ** 
 ** node - a node to store the data in
 **
 ** portPtr - pointer to port structure that offset is to be gotten from
 ** 
 ** port - This is the port number.
 **
 ** offset - Offset that will contain value to check for
 **
 ** type - This is the type of value that offset will contain.
 **        see plistnode structure in apgen.h
 **/
void FillPlistNode( node, portPtr, port, offset, type)
     PLISTNODE node;
     char *portPtr;
     int port;
     int offset;
     int type;
{
    unsigned int tempLong;
    unsigned short tempWord;

    bits_set(node->portList, port, port);
    switch (type)
	{
    case INTEGER_VALUE:
	{
	tempLong = GetDoubleWord((char *)(portPtr + offset));
	node->type.iValue = htonl (tempLong);
	break;
	}
	
    case SHORT_INT_VALUE:
	{
	tempWord = GetWord((char *) (portPtr + offset));
	node->type.siValue = (unsigned short) tempWord;
	break;
	}
    case CHAR_VALUE:
	{
	node->type.cValue = GetByte((char*)portPtr + offset);
	break;
	}
    case CHAR_PTR_VALUE:
	{
	node->type.pcValue = (char *) (portPtr + offset);
	break;
	}
    case GROUP_VALUE:
	{
	GroupListCopy( (char *) node->type.gValue, 
		      (char *) (portPtr + offset));
	break;
	}
    case CTRL_PORT_VALUE:
	{
	ControlledPortsCopy( (char *) node->type.ctrlpValue, 
		      (char *) (portPtr + offset));
	break;
	}
    case CHAR_EIGHT_VALUE:
	{
	strncpy( node->type.chr8Value, (char *) (portPtr + offset), 8);
	node->type.chr8Value[8] = '\0';
	break;
	}
    case ETHERNET_VALUE:
	{
	OurBCopy((char *) (portPtr + offset), (char *)node->type.ethValue, 6);
	break;
	}
	
	}
}

/*
 ** GeneratePortInfo()
 **
 */

void GeneratePortInfo( table, index, ports, explicit)
     INDEX_TABLE    table[];
     int            index;
     char           ports[TBITS_PORT_LIST_SIZE];
     unsigned int   explicit;
{
    int         portLoop = 0;
    int         numberOfPorts = 0;

    /*
     ** let's see if there are more than one port.  If not, then print it out
     ** verbosely,
     */
    
    for (portLoop = 0; portLoop< portNumber; portLoop++)
	{
	if (TST_ARRAY_BIT(ports, portLoop))
	    {
	    numberOfPorts++;
	    }
	}

    if ((!explicit) && (numberOfPorts > 1))
	{
	/*
	 ** There is more than one port, we'll take care of this.
	 ** We need to generate a port list for all the ports specified in
	 ** the ports bit list. 
	 */

	GenerateCondensedPortInfo( table, index, ports);
	}
    else
	{
	/*
	 ** They told us to do it explicitly... that means we don't want
	 ** to generate a port list for each port, but we do want
	 ** to step through each offset table before going on to the next port
	 */

	GenerateVerbosePortInfo( table, index, ports);
	} /* end else */

    } /* End GeneratePortInfo() */

/*
 ** GenerateCondensedPortInfo()
 ** 
 ** This routine will generate the Condensed version of port information, this
 ** is the default information that is generated.  It is generated in 
 ** port-list format so that the minimal amount of commands may be used to set 
 ** up the Comm Server. Port-list format means that many ports are specified 
 ** on a single command line by using the , or - as separators between numbers.
 ** ie. PORT 3-6, 4, 8 etc.
 **
 ** ARGUMENTS:
 **
 ** table - The INDEX_TABLE containg the port information to be displayed. This
 **         table is a index into offset tables containing port information.
 ** 
 ** index - The index # in the table[] that is to be displayed, or INDEX_ALL
 **         to display all info in table[].
 **
 ** ports - The port list of ports to display information for.
 */

void GenerateCondensedPortInfo( table, index, ports)
     INDEX_TABLE    table[];
     int            index;
     char           ports[TBITS_PORT_LIST_SIZE];
{
    int         indexLoop = 0, offsetLoop = 0, portLoop = 0, done = FALSE;
    int         nodeCount;
    char       *portPtr;
    PLISTNODE   nodePtr, portZeroNodePtr;
    PLIST       list;
    OFFSET_TABLE         *offsetTable;
    
    PlistInit( &list);

    while (table[indexLoop].index != INDEX_END)
	{
	if (table[indexLoop].index == INDEX_PPP)
	    {
	    if (pppParamsSeen)
		{
		table[indexLoop].offsetTable = pppOffsetTable;
		table[indexLoop].routine = PrintPortPPPData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 3;
		table[indexLoop].indexEcoVersion = 1;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    else
		{
		table[indexLoop].offsetTable = oldPppOffsetTable;
		table[indexLoop].routine = PrintPortOldPPPData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 1;
		table[indexLoop].indexEcoVersion = VERSION_DONT_CARE;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    }

	indexLoop++;
	}
    indexLoop = 0;

    while (table[indexLoop].index != INDEX_END)
	{
	if (table[indexLoop].index == INDEX_CCL)
	    {
	    if (cclParamsSeen)
		{
		table[indexLoop].offsetTable = cclOffsetTable;
		table[indexLoop].routine = PrintPortCCLData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 3;
		table[indexLoop].indexEcoVersion = 1;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    else
		{
		table[indexLoop].offsetTable = oldCclOffsetTable;
		table[indexLoop].routine = PrintPortOldCCLData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 3;
		table[indexLoop].indexEcoVersion = VERSION_DONT_CARE;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    }
	
	indexLoop++;
	}
    indexLoop = 0;
    
    /*
     ** There is more than one port, we'll take care of this.
     ** We need to generate a port list for all the ports specified in
     ** the ports bit list. 
     */
    
    if (index != INDEX_ALL)
	{
	/*
	 ** if we only have to do this for one offset table.
	 */
	indexLoop = index;
	}
    done = FALSE;
    if (index == INDEX_ALL) 
	{
	printf("#\n#echo *** Port Information ***\n#\n");    
	}
    while ((table[indexLoop].index != INDEX_END) && !done)
	{

	/*
	 ** We need to see if the version of this index in the index table
	 ** is valid for this version of parameter file.  If not, then
	 ** this parameter file don't support the information contained
	 ** at this index offset.
	 **/

	if ((VersionLaterOrEqual( table[indexLoop].indexMajorVersion,
				 table[indexLoop].indexMinorVersion,
				 table[indexLoop].indexEcoVersion,
				 table[indexLoop].indexTypeVersion,
				 table[indexLoop].indexPrereleaseVersion)) &&
	    ProductSupportsIndex( table[indexLoop].index ) &&
	    HardwareSupportsIndex( indexLoop))
	    {
	    printf("#\n#echo     %s\n#\n", table[indexLoop].header);
	    offsetTable = table[indexLoop].offsetTable;
	    offsetLoop = 0;
	    while (offsetTable[offsetLoop].offset != OFFSET_TABLE_END)
		{
		/*
		 ** Now we need to check the version of each
		 ** field in the offset table to see if we can show 
		 ** it or not.
		 */

		if (VersionLaterOrEqual( offsetTable[offsetLoop].offsetMajorVersion,
					offsetTable[offsetLoop].offsetMinorVersion,
					offsetTable[offsetLoop].offsetEcoVersion,
					offsetTable[offsetLoop].offsetTypeVersion,
					offsetTable[offsetLoop].offsetPrereleaseVersion))
		    {

		    for (portLoop = 1; portLoop < portNumber; portLoop++)
			{
			/*
			 ** Arap is a special case...It has it's port data coming
			 ** across each neatly packed in their own parameter 
			 ** segment.  So we set it up a table of pointer to the
			 ** ARAP port pointers the same way as the portTable 
			 ** points to the normal port data.  But, we still want
			 ** to print the arap data with the other port info so
			 ** that's why it is in the INDEX_TABLE.
			 ** The same goes for CONTROLLED PORTS.
			 */
			if (table[indexLoop].index == INDEX_ARAP)
			    {
			    /*
			     ** use arapTable for port information.
			     */
			    if (portLoop >= arapPortNumber)
				goto NextOffsetTable;
			    
			    portPtr = (char *)arapPortTable[portLoop];
			    }
			else if (table[indexLoop].index == INDEX_CONTROLLED_PORT)
			    {
			    /*
			     ** use controlledPortTable for port information.
			     */
			    if (portLoop >= controlledPortNumber)
				goto NextOffsetTable;
			    portPtr = (char *)controlledPortTable[portLoop];
			    }
			else if (table[indexLoop].index == INDEX_IPX_INTERFACE)
			    {
			    /*
			     ** use ipxInterface for port information.
			     */
			    if (portLoop >= ipxInterfaceNumber)
				goto NextOffsetTable;
			    portPtr = (char *)ipxInterface[portLoop];
			    }
			else if ((table[indexLoop].index == INDEX_PPP) &&
				 (pppParamsSeen))
			    {
			    /*
			     ** use PPP Table for port information.
			     */
			    if (portLoop >= pppPortNumber)
				goto NextOffsetTable;
			    portPtr = (char *)pppPortTable[portLoop];
			    }
			else if ((table[indexLoop].index == INDEX_CCL) &&
				 (cclParamsSeen))
			    {
			    /*
			     ** use CCL table for port information.
			     */
			    if (portLoop >= cclPortNumber)
				goto NextOffsetTable;
			    portPtr = (char *)cclPortTable[portLoop];
			    }
			else if (table[indexLoop].index == INDEX_EXPANDED_CHARACTERISTIC)
			    {
			    /*
			     ** use Expanded Port table for port information.
			     */
			    if (portLoop >= expandedPortNumber)
				goto NextOffsetTable;
			    portPtr = (char *)expandedPortTable[portLoop];
			    }
			else
			    {
			    /*
			     ** all other cases use the portTable.
			     */
			    portPtr = (char *)portTable[portLoop];
			    }
			
			if (TST_ARRAY_BIT(ports, portLoop))
			    {
			    AddPortToPlist( &list, portPtr, portLoop, 
					   offsetTable[offsetLoop].offset,
					   offsetTable[offsetLoop].type, ADD_TO_TAIL);
			    }
			}
		    /*
		     ** A little funky business to do...
		     ** Port zero is a special case, we want to print it in a 
		     ** port list whenever possible, except that it can't be
		     ** printed if ALL other ports have the same value.  SO
		     ** we know that for all other ports to have the same value
		     ** there would be only one node in the list.  If there are
		     ** multiple nodes in the list, just add port zero to it's 
		     ** corresponding value, otherwise if there's only one node
		     ** we better add another node for port zero.
		     **/
	    
		    if (TST_ARRAY_BIT(ports, PORT_ZERO))
			{
			/*
			 ** We need to set up the portPtr for either ARAP or
			 ** CONTROLLED ports, or a normal port.
			 */
			if (table[indexLoop].index == INDEX_ARAP)
			    {
			    /*
			     ** use arapTable for port information.
			     */
			    portPtr = (char *)arapPortTable[PORT_ZERO];
			    }
			else if (table[indexLoop].index == INDEX_CONTROLLED_PORT)
			    {
			    /*
			     ** use controlledPortTable for port information.
			     */
			    portPtr = (char *)controlledPortTable[PORT_ZERO];
			    }
			else if (table[indexLoop].index == INDEX_IPX_INTERFACE)
			    {
			    /*
			     ** use ipxInterface for port information.
			     */
			    portPtr = (char *)ipxInterface[PORT_ZERO];
			    }
			else if ((table[indexLoop].index == INDEX_PPP) && 
				 (pppParamsSeen))
			    {
			    portPtr = (char *)pppPortTable[PORT_ZERO];
			    }
			else if ((table[indexLoop].index == INDEX_CCL) && 
				 (cclParamsSeen))
			    {
			    portPtr = (char *)cclPortTable[PORT_ZERO];
			    }
			else if (table[indexLoop].index == INDEX_EXPANDED_CHARACTERISTIC)
			    {
			    portPtr = (char *)expandedPortTable[PORT_ZERO];
			    }
			else
			    {
			    /*
			     ** all other cases use the portTable.
			     */
			    portPtr = (char *)portTable[PORT_ZERO];
			    }

			/*
			 ** only do this if port zero is set
			 */
			nodePtr = list.head;
			nodeCount = 0;
			while(nodePtr != NULL_VALUE)
			    {
			    nodeCount++;
			    nodePtr = nodePtr->next;
			    }
			if (nodeCount > 1)
			    {
			    /*
			     ** more than one node, let's just add it.
			     */
			    AddPortToPlist( &list, portPtr, PORT_ZERO, 
					   offsetTable[offsetLoop].offset,
					   offsetTable[offsetLoop].type, ADD_TO_HEAD);
			    }
			else if ((nodeCount == 0) || (nodeCount == 1))
			    {
			    /*
			     ** This means all the ports in the list have the same
			     ** value.  We need to add a node no matter what!!!
			     */
			    portZeroNodePtr = AddPlistNodeToHead( &list);
			    FillPlistNode( portZeroNodePtr, portPtr, PORT_ZERO, 
					  offsetTable[offsetLoop].offset,
					  offsetTable[offsetLoop].type);
			    }
			}
		    
		    nodePtr = list.head;
		    while(nodePtr != NULL_VALUE)
			{
			/*
			 ** Call routine in offset table
			 */
			/* need extra verbose parameter for PPP routine */
			if (table[indexLoop].index == INDEX_PPP)  
			    (*table[indexLoop].routine)
			        ( nodePtr, offsetTable[offsetLoop].offset, FALSE);
			else
			    (*table[indexLoop].routine)
			        ( nodePtr, offsetTable[offsetLoop].offset);

			nodePtr = nodePtr->next;
			}
		    PlistFree(&list);

		    } /* End if VersionLaterOrEqual() for offset in offset table */

NextOffsetTable:
		offsetLoop++;
		} /* End while offset in offset table */

	    } /* End if VersionLaterOrEqual() for insdex in INDEX_TABLE */
	
	indexLoop++;
	if (index != INDEX_ALL)
	    {
	    /*
	     ** We only need to process the one index.
	     */
	    done = TRUE;
	    indexLoop = index;
	    }
	else
	    {
	    /*
	     ** Arap must be on the box in order to print the port related data.
	     */
	    if (table[indexLoop].index == INDEX_ARAP)
		{
		indexLoop++;
		}
	    }
	}  /* end while != INDEX_END */

    } /* End of GenerateCondensedPortInfo() */


/*
 ** GenerateVerbosePortInfo()
 ** 
 ** This routine will display port information individually for each port.
 ** It does not generate a port list for each port.
 **
 ** ARGUMENTS:
 **
 ** table - The INDEX_TABLE containg the port information to be displayed. This
 **         table is a index into offset tables containing port information.
 ** 
 ** index - The index # in the table[] that is to be displayed, or INDEX_ALL
 **         to display all info in table[].
 **
 ** ports - The port list of ports to display information for.
 */

void GenerateVerbosePortInfo( table, index, ports)
     INDEX_TABLE    table[];
     int            index;
     char           ports[TBITS_PORT_LIST_SIZE];
{
    int         indexLoop = 0, offsetLoop = 0, portLoop = 0, done = FALSE;
    char       *portPtr;
    PLISTNODE   nodePtr;
    PLIST       list;
    OFFSET_TABLE         *offsetTable;
    
    PlistInit( &list);

    while (table[indexLoop].index != INDEX_END)
	{
	if (table[indexLoop].index == INDEX_PPP)
	    {
	    if (pppParamsSeen)
		{
		table[indexLoop].offsetTable = pppOffsetTable;
		table[indexLoop].routine = PrintPortPPPData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 3;
		table[indexLoop].indexEcoVersion = 1;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    else
		{
		table[indexLoop].offsetTable = oldPppOffsetTable;
		table[indexLoop].routine = PrintPortOldPPPData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 1;
		table[indexLoop].indexEcoVersion = VERSION_DONT_CARE;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    }
	indexLoop++;
	}
    indexLoop = 0;

    while (table[indexLoop].index != INDEX_END)
	{
	if (table[indexLoop].index == INDEX_CCL)
	    {
	    if (cclParamsSeen)
		{
		table[indexLoop].offsetTable = cclOffsetTable;
		table[indexLoop].routine = PrintPortCCLData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 3;
		table[indexLoop].indexEcoVersion = 1;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    else
		{
		table[indexLoop].offsetTable = oldCclOffsetTable;
		table[indexLoop].routine = PrintPortOldCCLData;
		table[indexLoop].indexMajorVersion = 5;
		table[indexLoop].indexMinorVersion = 3;
		table[indexLoop].indexEcoVersion = VERSION_DONT_CARE;
		table[indexLoop].indexPrereleaseVersion = VERSION_DONT_CARE;
		table[indexLoop].indexTypeVersion = VERSION_DONT_CARE;
		}
	    }
	indexLoop++;
	}
    indexLoop = 0;

    /*
     ** They told us to do it explicitly... that means we don't want
     ** to generate a port list for each port, but we do want
     ** to step through each offset table before going on to the next port
     */
    
    for (portLoop = 0; portLoop < portNumber; portLoop++)
	{
	if (index != INDEX_ALL)
	    {
	    /*
	     ** if we only have to do this for one offset table.
	     */
	    indexLoop = index;
	    }
	else
	    {
	    indexLoop = 0;
	    }		
	done = FALSE;
	if (index == INDEX_ALL) 
	    {
	    /*		printf("#\n#echo *** Port %d ", portLoop);  */
	    }
	while ((table[indexLoop].index != INDEX_END) && !done)
	    {
	    /*
	     ** We need to see if the version of this index in the index table
	     ** is valid for this version of parameter file.  If not, then
	     ** this parameter file don't support the information contained
	     ** at this index offset.
	     **/

	    if ((VersionLaterOrEqual( table[indexLoop].indexMajorVersion,
				    table[indexLoop].indexMinorVersion,
				    table[indexLoop].indexEcoVersion,
				    table[indexLoop].indexTypeVersion,
				    table[indexLoop].indexPrereleaseVersion))&&
		ProductSupportsIndex( table[indexLoop].index ) &&
		HardwareSupportsIndex( indexLoop))
		{
		if (TST_ARRAY_BIT(ports,portLoop) && 
		    ((portLoop != 0) || 
		     ((portLoop == 0) && ((indexLoop != INDEX_SLIP) &&
					  (indexLoop != INDEX_XREMOTE) && 
					  (indexLoop != INDEX_PPP) &&
					  (indexLoop != INDEX_IPX_INTERFACE)))))
		    {
		    /*
		     ** Don't want header printed for port 0 in these cases
		     */
		    printf("#\n#echo     %s - Port %d\n#\n", 
			   table[indexLoop].header, portLoop);
		    }
		offsetTable = table[indexLoop].offsetTable;
		offsetLoop = 0;
		while (offsetTable[offsetLoop].offset != OFFSET_TABLE_END)
		    {
		    /*
		     ** Now we need to check the version of each
		     ** field in the offset table to see if we can show 
		     ** it or not.
		     */
		    if (VersionLaterOrEqual( offsetTable[offsetLoop].offsetMajorVersion,
					    offsetTable[offsetLoop].offsetMinorVersion,
					    offsetTable[offsetLoop].offsetEcoVersion,
					    offsetTable[offsetLoop].offsetTypeVersion,
					    offsetTable[offsetLoop].offsetPrereleaseVersion))
			{
			if (TST_ARRAY_BIT(ports, portLoop))
			    {
			    /*
			     ** Arap is a special case...It has it's port data coming
			     ** across each neatly packed in their own parameter 
			     ** segment.  So we set it up a table of pointer to the
			     ** ARAP port pointers the same way as the portTable 
			     ** points to the normal port data.  But, we still want
			     ** to print the arap data with the other port info so
			     ** that's why it is in the INDEX_TABLE.
			     */
			    if (table[indexLoop].index == INDEX_ARAP)
				{
				/*
				 ** use arapTable for port information.
				 */
				if (portLoop >= arapPortNumber)
				    goto nextOffset;
				portPtr = (char *)arapPortTable[portLoop];
				}
			    else if (table[indexLoop].index == INDEX_CONTROLLED_PORT)
				{
				/*
				 ** use controlledPortTable for port information.
				 */
				if (portLoop >= controlledPortNumber)
				    goto nextOffset;
				portPtr = (char *)controlledPortTable[portLoop];
				}
			    else if (table[indexLoop].index == INDEX_IPX_INTERFACE)
				{
				/*
				 ** use ipxInterface for port information.
				 */
				if (portLoop >= ipxInterfaceNumber)
				    goto nextOffset;
				portPtr = (char *)ipxInterface[portLoop];
				}
			    else if ((table[indexLoop].index == INDEX_PPP) &&
				     (pppParamsSeen))
				{
				/*
				 ** use ipxInterface for port information.
				 */
				if (portLoop >= pppPortNumber)
				    goto nextOffset;
				portPtr = (char *)pppPortTable[portLoop];
				}
			    else if ((table[indexLoop].index == INDEX_CCL) &&
				     (cclParamsSeen))
				{
				/*
				 ** use ipxInterface for port information.
				 */
				if (portLoop >= cclPortNumber)
				    goto nextOffset;
				portPtr = (char *)cclPortTable[portLoop];
				}
			    else if (table[indexLoop].index == INDEX_EXPANDED_CHARACTERISTIC) 
				{
				/*
				 ** use expanded port for port information.
				 */
				if (portLoop >= expandedPortNumber)
				    goto nextOffset;
				portPtr = (char *)expandedPortTable[portLoop];
				}

			    else
				{
				/*
				 ** all other cases use the portTable.
				 */
				portPtr = (char *)portTable[portLoop];
				}
			    
			    AddPortToPlist( &list, portPtr, portLoop, 
					   offsetTable[offsetLoop].offset,
					   offsetTable[offsetLoop].type, ADD_TO_TAIL);
			    nodePtr = list.head;
			    while(nodePtr != NULL_VALUE)
				{
				/*
				 ** Call routine in offset table
				 */
				/* need extra verbose parameter for PPP routine */
				if (table[indexLoop].index == INDEX_PPP)  
			    		(*table[indexLoop].routine)
			        	( nodePtr, offsetTable[offsetLoop].offset, TRUE);
				else
			    		(*table[indexLoop].routine)
			        	( nodePtr, offsetTable[offsetLoop].offset);

				nodePtr = nodePtr->next;
				}
			    PlistFree(&list);
			    } /* end if TST_ARRAY_BIT */
			} /* End if VersionLaterOrEqual() for each field in table */

nextOffset:		    
		    offsetLoop++;
		    } /* end while != OFFSET_TABLE_END */

		} /* End If VersionLaterOrEqual()  for INDEX in index table */
	    
	    indexLoop++;
	    if (index != INDEX_ALL)
		{
		/*
		 ** We only need to process the one index.
		 */
		done= TRUE;
		}
	    else
		{
		/*
		 ** Arap must be on the box in order to print the port related data.
		 */
		if (table[indexLoop].index == INDEX_ARAP)
		    {
		    indexLoop++;
		    }
		}
	    }/* end while != INDEX_END  && ! done */
	} /* end for portLoop */

    } /* End GenerateVerbosePortInfo() */
