


CSPORTD(l)        MISC. REFERENCE MANUAL PAGES         CSPORTD(l)



NAME
     csportd - Comm Server Port Daemon

SYNOPSIS
     csportd [ -d _d_e_b_u_g-_l_e_v_e_l ] [ -P _p_i_p_e-_n_a_m_e ] [ -T _p_t_y-_n_a_m_e  ]
     [ -c _c_o_n_f_i_g-_f_i_l_e ] [ -xtgwLeDiso ] _C_o_m_m_S_e_r_v_e_r _P_o_r_t

DESCRIPTION
     _c_s_p_o_r_t_d is a utility which gives users connectivity  between
     UNIX  systems and Comm Server ports. _c_s_p_o_r_t_d reads data from
     stdin, a pseudo terminal or a FIFO (named  pipe)  and  sends
     the  data  to  the  Comm Server port.  Likewise, data can be
     read from the Comm Server port and sent to the pseudo termi-
     nal or FIFO.

     Many options are available to control how _c_s_p_o_r_t_d  processes
     the data.  Refer to the OPTIONS section for details.

ARGUMENTS
     -options
           Any valid set of options as described below.

     CommServer
           Name or IP address of a Comm Server.

     Port  Physical or logical port number on the Comm Server  to
           send  (receive)  the  data to (from).  Refer to the -L
           option.

OPTIONS
     The following options control where  _c_s_p_o_r_t_d  reads  (sends)
     data  from (to) and how to process any data going to (coming
     from) the Comm Server port.

     -d debug-level
           Sets the debug level to  _d_e_b_u_g-_l_e_v_e_l.  Increasing  the
           _d_e_b_u_g-_l_e_v_e_l  increases  the  verbosity of the messages
           displayed.  The following values are supported.

           1 - General information and any system error messages.

           2 - Buffer processing information.

           3 - select() information.

           Any value greater than 3 is set to 3.

     -P pipe-name
           Creates a named pipe (FIFO)  of  the  name  _p_i_p_e-_n_a_m_e.
           Data  written  to  the  file  will be sent to the Comm
           Server port. Data read from this  file  will  be  data
           read  from  the  Comm  Server  port, unless explicitly



Sun Release 4.1     Last change: 17 June 1993                   1






CSPORTD(l)        MISC. REFERENCE MANUAL PAGES         CSPORTD(l)



           stated otherwise by use  of  the  -t  or  -w  options.
           Ideally,  the Comm Server port should have the default
           session mode defined to  be  TRANSPARENT.   Note  that
           with  pipes,  a  FIFO opened for for reading will pend
           until the other end is opened for writing, and a  FIFO
           opened  for  writing  will pend until the other end is
           opened for reading.  The -P and -T options  are  mutu-
           ally  exclusive,  while  the  -D  and  -e  options are
           invalid with this option.

     -T pty-name
           Allocates a pseudo terminal and creates a link  to  it
           named  _p_t_y-_n_a_m_e.  Any data written to _p_t_y-_n_a_m_e is sent
           to the Comm Server port while data read from the  Comm
           Server  port is written to _p_t_y-_n_a_m_e. Ideally, the Comm
           Server port  should  have  the  default  session  mode
           defined  to  be  TRANSPARENT.   If the default session
           mode is not  TRANSPARENT,  the  -t  option  should  be
           specified  otherwise  functionality  may be unpredict-
           able.  The -T and -P options are mutually exclusive.

           AIX SYSTEMS

           The link to the psuedo terminal  must  be  a  symbolic
           one.  Therefore, the -s option must also be specified.


     -c    Read pseudo terminal names from _c_o_n_f_i_g-_f_i_l_e instead of
           using  _c_s_p_o_r_t_d'_s allocation algorithm.  Useful in res-
           tricting which PTYs are used or if your system  has  a
           unique  PTY  naming  strategy.   This  option may only
           appear after the -T option.  A sample _c_o_n_f_i_g-_f_i_l_e is:

           #
           #  a '#" denotes a comment line
           #
           /dev/ptyq0
           /dev/ptyq1

     -x   converts LFs to LFCRs in data going to the Comm  Server
          port.

     -t   limited TELNET mode.  TELNET IAC characters are doubled
          in  data  going  to  the Comm Server port while doubled
          TELNET IAC characters are converted  to  single  TELNET
          IAC  characters  in  data  coming  from the Comm Server
          port.  Any TELNET option negotiations received from the
          Comm  Server  are negatively acknowledged.  This option
          should be specified when the default  session  mode  on
          the Comm Server port is not TRANSPARENT.

     -g   connect through a TCPIP/LAT gateway.



Sun Release 4.1     Last change: 17 June 1993                   2






CSPORTD(l)        MISC. REFERENCE MANUAL PAGES         CSPORTD(l)



     -w   write only mode.   Any  data  received  from  the  Comm
          Server is ignored.

     -L   _p_o_r_t argument is a logical (TCP) port instead of a phy-
          sical port.  This argument needs to be specified if the
          default TELNET remote port was changed for the physical
          port.

     -e   TELNET EOR reflection at the end of jobs.  This  option
          requires  that  eor  reflection  be enabled on the Comm
          Server Port.  (Comm Server command  ->  DEFINE  PORT  x
          TELNET  EOR REFLECTION ENABLED).  For eor reflection to
          work properly, the default session  mode  of  the  Comm
          Server  port  MUST  NOT  be  set  to TRANSPARENT.  This
          option is incompatible with the -P option.

     -D   disconnect from the  Comm  Server  port  between  jobs.
          Typically, job end is detected when a last close occurs
          on the user device which causes the  error  EIO  to  be
          sent  to _c_s_p_o_r_t_d. This option may only appear after the
          -T option and cannot appear with the -o option  and  -P
          option.

     -i   initiate the connection  with  the  Comm  Server  port.
          Normally  _c_s_p_o_r_t_d  will  wait  for  input from the user
          before registering with the Comm Server and waiting for
          the  callback.  This option causes _c_s_p_o_r_t_d to establish
          the connection with the Comm  Server  port  before  any
          data needs to be sent.

     -s   create a symbolic link for  _p_t_y-_n_a_m_e  This  option  may
          only appear after the -T option.

     -o   toggles PTY slave processing.  This option toggles  the
          processing  done  by  the  slave  side of the PTY.  The
          actions taken depend on the system type.

          BSD Systems

          The slave side of the PTY is opened configured for  RAW
          mode.

          System V Systems

          The slave side of the PTY is opened  and  the  terminal
          emulation  modules  "ptem" and "ldterm" are pushed onto
          the stream.

          Incompatible with the -D,-e and -P  options.

EXAMPLES
     Some exammples of how to use _c_s_p_o_r_t_d are:



Sun Release 4.1     Last change: 17 June 1993                   3






CSPORTD(l)        MISC. REFERENCE MANUAL PAGES         CSPORTD(l)



     1.   To send a file to port 5 of a  Comm  Server  port,  one
          might use:

              % cat file | csportd CommServer 5

     2.   To send the same file, but convert  LFs  to  LFCRs  and
          print out all debug information, one might use:

              % cat file | csportd -d3 -x CommServer 5

     3.   To create an entry in /dev which will  allow  users  to
          send  data  to  the  Comm Server port, one could do the
          following:

              % csportd -T/dev/foo -D CommServer 5

          Users can then send data to the port with:

              % cat file >/dev/foo

     4.   To accomplish the same goal using a named pipe  (FIFO),
          one could do the following:

              % csportd -P/usr/spool/CommServerPort -x CommServer 5

          Users can then send data to the port with:


              % cat file >/usr/spool/CommServerPort

     5    To create a permanent connection to the port which  can
          be  used  by the system to provide a "hardwire" connec-
          tion to a terminal attached to the Comm Server port, do
          the following:  (BSD systems only!)

          Add the following line to /etc/ttytab.

              ttyCS1  "/usr/etc/getty maxserver"  unknown on local secure

          Add the following entry to /etc/gettytab

              maxserver:\
                         :p8:lm=\r\n\r\nWelcome to %h\r\nlogin\72 :

          Start up _c_s_p_o_r_t_d.

              % csportd -T/dev/ttyCS1 -i CommServer 5 &

          Signal the init process to read /etc/ttytab.

              % kill -HUP 1




Sun Release 4.1     Last change: 17 June 1993                   4






CSPORTD(l)        MISC. REFERENCE MANUAL PAGES         CSPORTD(l)



          The login prompt should now appear on the terminal con-
          nected to the Comm Server port.

FILES
     /dev/file-name          Link to PTY slave.
     pipe-file               Pipe file.

     BSD

       /dev/pty[p-s][0-f]    list of PTY masters
       /dev/tty[p-s][0-f]    list of PTY slaves

     System V

       /dev/ptmx             PTY master device



SEE ALSO
     Supporting documentation.



































Sun Release 4.1     Last change: 17 June 1993                   5



