/*
 *
 *	RADIUS
 *	Remote Authentication Dial In User Service
 *
 * ASCEND: @(#)builddbm.c	1.2 (95/07/25 00:55:26)
 *
 *
 *	Livingston Enterprises, Inc.
 *	6920 Koll Center Parkway
 *	Pleasanton, CA   94566
 *
 *	Copyright 1992 Livingston Enterprises, Inc.
 *
 *	Permission to use, copy, modify, and distribute this software for any
 *	purpose and without fee is hereby granted, provided that this
 *	copyright and permission notice appear on all copies and supporting
 *	documentation, the name of Livingston Enterprises, Inc. not be used
 *	in advertising or publicity pertaining to distribution of the
 *	program without specific prior permission, and notice be given
 *	in supporting documentation that copying and distribution is by
 *	permission of Livingston Enterprises, Inc.   
 *
 *	Livingston Enterprises, Inc. makes no representations about
 *	the suitability of this software for any purpose.  It is
 *	provided "as is" without express or implied warranty.
 *
 */

/* $Id: builddbm.c,v 1.2 1996/12/12 00:04:38 baskar Exp $ */

static char sccsid[] =
"@(#)builddbm.c	1.4 Copyright 1992 Livingston Enterprises Inc";

#if defined(SOLARIS)
#       include <sys/uio.h>
#       include <unistd.h>
#       include <sys/stat.h>
#       include <fcntl.h>
#       include </usr/ucbinclude/dbm.h>
#else
#       include <dbm.h>
#endif  /* SOLARIS */

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<string.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>

#include	"radius.h"
#include	"protos.h"

char		*progname;
char		*radius_dir;
char		*radius_users;
char		pagfile[256];
char		dirfile[256];
char		dbmname[256];
FILE		*userfd;
FILE		*errf;
extern int	curParseLine;
int		verbose;
extern int	warning;

#if !defined(FALSE)
#  define FALSE	0
#  define TRUE	1
#endif

int main P__((int argc, char **argv));

int
main(argc, argv)
int	argc;
char	**argv;
{
	char	name[128];
	char	content[4 * 1024];
	int	fd;
	datum	named;
	datum	contentd;
	int	c;
	extern char	*optarg;
	extern int	optind, opterr;

	progname = *argv;
	radius_dir = RADIUS_DIR;
	radius_users = RADIUS_USERS;
	errf = stderr;
	verbose = FALSE;
	warning = TRUE;

	while( (c = getopt(argc, argv, "d:ehu:v")) != -1 ) {
		switch( c ) {
		case 'h':
		case '?':
		default:
			printf("\n%s options are:\n%s%s%s%s%s\n", progname,
				"\t-d dir\t\tradius directory\n",
				"\t-e\t\tuse stdout rather than stderr\n",
				"\t-h\t\trequest help\n",
				"\t-u file\t\tradius users file\n",
				"\t-v\t\tverbose mode\n"
			);
			return -1;
		case 'd':
			radius_dir = optarg;
			break;
		case 'e':
			errf = stdout;
			break;
		case 'u':
			radius_users = optarg;
			break;
		case 'v':
			verbose = TRUE;
			break;
		}
	}

	sprintf(pagfile, "%s/%s.pag", radius_dir, radius_users);
	if((fd = open(pagfile, O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0) {
		fprintf(errf, "%s: Couldn't open %s for writing\n",
			progname, pagfile);
		exit(-1);
	}
	close(fd);
	sprintf(dirfile, "%s/%s.dir", radius_dir, radius_users);
	if((fd = open(dirfile, O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0) {
		fprintf(errf, "%s: Couldn't open %s for writing\n",
			progname, dirfile);
		exit(-1);
	}
	close(fd);
	sprintf(dbmname, "%s/%s", radius_dir, radius_users);
	if(dbminit(dbmname) != 0) {
		fprintf(errf, "%s: Couldn't dbminit(%s)\n", progname, dbmname);
		exit(-1);
	}

	userfd = (FILE *)NULL;
	curParseLine = 0;
	while(user_read(&userfd, name, content) == 0) {
		if( verbose ) {
			fprintf(stdout, "\nRECORD: {'%s', '%s'}\n",
				name, content);
		}
		named.dptr = name;
		named.dsize = strlen(name)+1;
		contentd = fetch(named);
		if(contentd.dsize != 0) {	/* name found */
			warn("Skipping duplicate record\n\tfor user '%s'", name);
			continue;
		}
		named.dptr = name;
		named.dsize = strlen(name)+1;
		contentd.dptr = content;
		contentd.dsize = strlen(content)+1;
		if(store(named, contentd) != 0) {
			fprintf(errf, "%s: Couldn't store datum for %s\n",
				progname, name);
			exit(-1);
		}
	}
	dbmclose();
	exit(0);
}

