/*
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *	Permission to copy all or part of this material for any purpose is
 *	granted provided that the above copyright notice and this paragraph
 *	are duplicated in all copies.  THIS SOFTWARE IS PROVIDED ``AS IS''
 *	AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE.
 *
 *	Written by Greg McGary <gkm@cstone.net>, August 1996
 */

/* $Id: hash.h,v 1.2 1996/12/12 00:04:47 baskar Exp $ */

#ifndef _hash_h_
#define _hash_h_

#include "conf.h"

typedef unsigned long (*hash_func_t) P__((void CONST *key));
typedef int (*hash_compare_func_t) P__((void CONST *x, void CONST *y));
typedef void (*hash_iter_func_t) P__((void *item, void *arg));

struct hash_table
{
  void **ht_vector;
  unsigned long ht_size;	/* must be power of 2 */
  unsigned long ht_capacity;
  unsigned long ht_cardinality;
  hash_func_t ht_hash_1;
  hash_func_t ht_hash_2;
  hash_compare_func_t ht_compare;
};

void hash_init P__((struct hash_table *ht, unsigned long size,
		    hash_func_t hash_1, hash_func_t hash_2, hash_compare_func_t hash_cmp));
void **hash_find_slot P__((struct hash_table *ht, void CONST *key));
void *hash_insert P__((struct hash_table *ht, void *item));
void *hash_insert_at P__((struct hash_table *ht, void *item, void *slot));
void *hash_delete_at P__((struct hash_table *ht, void *slot));
void hash_delete_all P__((struct hash_table* ht));
void hash_iterate P__((struct hash_table *ht, hash_iter_func_t iter_func, void *arg));
void **hash_dump P__((struct hash_table *ht, void **vector_0));

extern void *hash_deleted_item;
#define HASH_VACANT(item) ((item) == 0 || (void *) (item) == hash_deleted_item)
#define HASH_NULLIFY(slot) (*(void **) (slot) = hash_deleted_item)

#endif /* not _hash_h_ */
