/*
 * ASCEND: @(#)protos.h	1.3 (95/07/25 00:55:32)
 *
 *      Copyright (c) 1995 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *	Permission to copy all or part of this material for any purpose is
 *	granted provided that the above copyright notice and this paragraph
 *	are duplicated in all copies.  THIS SOFTWARE IS PROVIDED ``AS IS''
 *	AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE.
 */

/* $Id: protos.h,v 1.4 1997/02/06 06:11:22 gkm Exp $ */

#ifndef _protos_h_
#define _protos_h_

#include "conf.h"

	/* function prototypes */
#if defined(SOLARIS)
	extern int getopt P__((int, char *CONST *, CONST char *));
#endif
#if defined(_SVID_GETTOD)
	extern int gettimeofday P__((struct timeval *tp));
#else
# if defined(OSUN)
	extern int gettimeofday P__((struct timeval *tp, struct timezone *tzp));
# endif
#endif
extern void radversion P__((void));
extern CONST char *get_errmsg P__((int errcode));
extern int authenticateAcctReq P__((AUTH_REQ *authreq, AUTH_HDR *auth));
extern DICT_ATTR *dict_attrfind P__((CONST char *attrname));
extern DICT_ATTR *dict_attrget P__((int attribute));
extern DICT_VALUE *dict_valfind P__((CONST char *valname));
extern DICT_VALUE *dict_valget P__((UINT4 value, CONST char *attrname));
extern UINT4 get_ipaddr P__((char *host));
extern UINT4 ipstr2long P__((char *ip_str));
extern CONST char *ip_hostname P__((UINT4 ipaddr));
extern int get_client_info P__((UINT4 rqstIpAddr, UINT4 *ipaddr, u_char *secret, char *hostnm));
extern int calc_digest P__((u_char *digest, AUTH_REQ *authreq));
extern int config_init P__((void));
extern int dict_init P__((void));
extern int filterBinary P__((VALUE_PAIR *pair, char *valstr));
extern int good_ipaddr P__((char *addr));
extern int kill P__((pid_t pid, int sig));
extern int log_err P__((CONST char *fmt, ...));
extern void debugf P__((CONST char *fmt, ...));
extern int pw_expired P__((UINT4 exptime, UINT4 usr_exp_days, UINT4 usr_warn_days));
extern void radrespond P__((AUTH_REQ *authreq, int activefd, int isAcctPkt));
extern int set_expiration P__((VALUE_PAIR *user_check, UINT4 expiration));
extern int unix_pass P__((CONST char *name, char *passwd));
extern int user_find P__((char *name, VALUE_PAIR **check_pairs, VALUE_PAIR **reply_pairs));
extern int user_update P__((char *name, VALUE_PAIR *user_check, VALUE_PAIR *user_reply));
extern void debug_pair P__((char const *prefix, FILE *fd, VALUE_PAIR *pair));
extern void fprint_attr_val P__((FILE *fd, VALUE_PAIR *pair));
extern void ipaddr2str P__((char *buffer, UINT4 ipaddr));
extern void md5_calc P__((unsigned char *output, unsigned char *input, unsigned int inlen));
extern void pairfree P__((VALUE_PAIR *pair));
extern void rad_accounting P__((AUTH_REQ *authreq, int activefd, int isEventRequest));
extern int rad_authenticate P__((AUTH_REQ *authreq, int activefd));
extern void rad_passchange P__((AUTH_REQ *authreq, int activefd));
extern void send_accept P__((AUTH_REQ *authreq, VALUE_PAIR **reply_ptr, CONST char *msg, int activefd));
extern PasswordType getPasswordType P__((char *pwd));
extern UINT4 get_attr_lvalue P__((VALUE_PAIR *list, int attribute));
extern char *get_attr_strvalue P__((VALUE_PAIR *list, int attribute));
extern void send_acct_reply P__((AUTH_REQ *authreq, VALUE_PAIR *reply, CONST char *msg, int activefd, int isEventRequest));
extern void send_challenge P__((AUTH_REQ *authreq, CONST char *msg, int msgLen,
				CONST char *state, int stateLen, int activefd));
extern void send_newpin P__((AUTH_REQ *authreq, CONST char *state,
			     int stateLen, int activefd));
extern void send_nextcode P__((AUTH_REQ *authreq, CONST char *msg, int msgLen,
			       CONST char *state, int stateLen, int activefd));
extern void send_pwack P__((AUTH_REQ *authreq, int activefd));
extern void send_pwexpired P__((AUTH_REQ *authreq, CONST char *msg, int activefd));
extern void make_secret P__((u_char *digest, u_char *vector, u_char *secret, char *value));
extern void send_reject P__((AUTH_REQ *authreq, CONST char *msg, int activefd));
extern int user_read P__((FILE **userfd, char *name, char *content));
extern int user_wants_ace P__((char *user_name, int *immediate));
char *get_user_name P__((AUTH_REQ *authreq, CONST char *where));
char *get_user_values P__((AUTH_REQ *authreq, VALUE_PAIR **check_pairs,
			   VALUE_PAIR **reply_pairs, CONST char *where));
UINT4 get_framed_address P__((AUTH_REQ *authreq, CONST char *where));
UINT4 get_router_address P__((AUTH_REQ *authreq, CONST char *where));
struct sockaddr *remote_sockaddr P__((AUTH_REQ *authreq));
int append_user_message P__((u_char *destination, CONST char *source, int max_length));
AUTH_HDR *make_send_buffer P__((AUTH_REQ *authreq, int code));
void send_answer P__((int fd, AUTH_REQ *authreq, AUTH_HDR *auth, int length));
VALUE_PAIR *make_pair P__((CONST char *name, int code, int type));

#endif /* _protos_h_ */
